/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.orient;

import com.hazelcast.core.HazelcastInstance;
import com.orientechnologies.orient.core.serialization.OStreamableHelper;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.distributed.task.ODistributedLockException;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.OPossibleDuplicatedRecordException;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import com.sonatype.nexus.hazelcast.internal.orient.SharedHazelcastPlugin;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.OrientConfigCustomizer;
import org.sonatype.nexus.transaction.ExceptionFilter;
import org.sonatype.nexus.transaction.RetryController;

@Named
@Singleton
public class SharedHazelcastConfig
extends OServerHandlerConfiguration
implements OrientConfigCustomizer {
    @Nullable
    private final String localHostAddress;

    @Inject
    public SharedHazelcastConfig(ApplicationDirectories applicationDirectories, Provider<HazelcastInstance> hazelcastProvider, NodeAccess nodeAccess, RetryController retryController) throws IOException {
        File configDir = applicationDirectories.getConfigDirectory("fabric");
        boolean enabled = nodeAccess.isClustered();
        if (enabled) {
            this.localHostAddress = ((HazelcastInstance)hazelcastProvider.get()).getCluster().getLocalMember().getAddress().getHost();
            ExceptionFilter majorExceptionFilter = retryController.majorExceptionFilter();
            majorExceptionFilter.addException(ODistributedOperationException.class);
            majorExceptionFilter.addException(ODistributedLockException.class);
            majorExceptionFilter.addException(ODistributedRecordLockedException.class);
            majorExceptionFilter.addException(OPossibleDuplicatedRecordException.class);
            majorExceptionFilter.addException(ORecordDuplicatedException.class);
        } else {
            this.localHostAddress = null;
        }
        this.clazz = SharedHazelcastPlugin.class.getName();
        this.parameters = new OServerParameterConfiguration[]{new OServerParameterConfiguration("enabled", Boolean.toString(enabled)), new OServerParameterConfiguration("nodeName", nodeAccess.getId()), new OServerParameterConfiguration("configuration.db.default", new File(configDir, "orientdb-distributed.json").getCanonicalPath()), new OServerParameterConfiguration("configuration.hazelcast", new File(configDir, "hazelcast.xml").getCanonicalPath())};
        OStreamableHelper.setStreamableClassLoader((ClassLoader)new ClassLoader(OHazelcastPlugin.class.getClassLoader()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (name.startsWith("[")) {
                    return Class.forName(name, false, this.getParent());
                }
                return this.getParent().loadClass(name);
            }
        });
    }

    public void apply(OServerConfiguration config) {
        if (this.localHostAddress != null) {
            for (OServerNetworkListenerConfiguration listener : config.network.listeners) {
                if (!"binary".equals(listener.protocol)) continue;
                listener.ipAddress = this.localHostAddress;
            }
        }
    }
}

