/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.sonatype.nexus.hazelcast.internal.orient.OCheckIndexTool;
import com.sonatype.nexus.hazelcast.internal.orient.SharedHazelcastPlugin;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.DatabaseInstanceNames;
import org.sonatype.nexus.orient.DatabaseMaintenanceService;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.quorum.DatabaseQuorumResetEvent;
import org.sonatype.nexus.orient.quorum.DatabaseQuorumStatus;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
@Singleton
public class DatabaseMaintenanceServiceImpl
extends ComponentSupport
implements DatabaseMaintenanceService {
    private final Provider<OServer> serverProvider;
    private final DatabaseManager databaseManager;
    private final NodeAccess nodeAccess;
    private final EventManager eventManager;

    @Inject
    public DatabaseMaintenanceServiceImpl(Provider<OServer> serverProvider, DatabaseManager databaseManager, NodeAccess nodeAccess, EventManager eventManager) {
        this.serverProvider = (Provider)Preconditions.checkNotNull(serverProvider);
        this.databaseManager = (DatabaseManager)Preconditions.checkNotNull((Object)databaseManager);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    public DatabaseQuorumStatus getQuorumStatus() {
        DatabaseQuorumStatus status = DatabaseQuorumStatus.singleNode();
        if (!this.nodeAccess.isClustered()) {
            return status;
        }
        for (String databaseName : DatabaseInstanceNames.DATABASE_NAMES) {
            status = this.getQuorumStatus(databaseName);
            if (status.isQuorumPresent()) continue;
            return status;
        }
        return status;
    }

    public DatabaseQuorumStatus getQuorumStatus(String databaseName) {
        DatabaseMaintenanceServiceImpl.checkDatabaseName(databaseName);
        if (!this.nodeAccess.isClustered()) {
            return DatabaseQuorumStatus.singleNode();
        }
        ODistributedServerManager serverManager = ((OServer)this.serverProvider.get()).getDistributedManager();
        List onlineNodes = serverManager.getOnlineNodes(databaseName);
        ODistributedConfiguration configuration = serverManager.getDatabaseConfiguration(databaseName);
        Set members = configuration.getAllConfiguredServers();
        int writeQuorum = configuration.getWriteQuorum(null, members.size(), null);
        return new DatabaseQuorumStatus((Collection)onlineNodes, writeQuorum, databaseName, (Collection)members);
    }

    public void resetWriteQuorum() {
        ODistributedServerManager distributedServerManager = ((OServer)this.serverProvider.get()).getDistributedManager();
        if (distributedServerManager == null || !this.nodeAccess.isClustered()) {
            this.log.info("Cannot reset write quorum for non-clustered database");
            return;
        }
        this.log.info("Resetting write quorum by removing all nodes except {}", (Object)this.nodeAccess.getId());
        this.hazelcastPlugin().resetWriteQuorum();
        this.log.info("Write quorum has been reset");
        this.eventManager.post((Object)new DatabaseQuorumResetEvent());
    }

    public void logServersStatus() {
        if (!this.nodeAccess.isClustered()) {
            this.log.info("Databases in non-clustered mode");
        } else {
            this.hazelcastPlugin().forceDumpServersStatus();
        }
    }

    public String fullServerStatus() {
        return this.hazelcastPlugin().fullServerStatus();
    }

    public Map<String, Object> profilerStatistics() {
        return this.hazelcastPlugin().profilerStatistics();
    }

    public String getDatabaseRole(String databaseName) {
        DatabaseMaintenanceServiceImpl.checkDatabaseName(databaseName);
        return this.whenClustered("getDatabaseRole", () -> this.getServerRole(databaseName).name());
    }

    public void setDatabaseRole(String databaseName, String role) {
        DatabaseMaintenanceServiceImpl.checkDatabaseName(databaseName);
        this.whenClustered("setDatabaseRole", () -> this.setServerRole(databaseName, ODistributedConfiguration.ROLES.valueOf((String)role)));
    }

    public String getDatabaseStatus(String databaseName) {
        DatabaseMaintenanceServiceImpl.checkDatabaseName(databaseName);
        return this.whenClustered("getDatabaseStatus", () -> this.hazelcastPlugin().getDatabaseStatus(this.nodeAccess.getId(), databaseName).name());
    }

    public void setDatabaseStatus(String databaseName, String status) {
        DatabaseMaintenanceServiceImpl.checkDatabaseName(databaseName);
        this.whenClustered("setDatabaseStatus", () -> this.hazelcastPlugin().setDatabaseStatus(this.nodeAccess.getId(), databaseName, ODistributedServerManager.DB_STATUS.valueOf((String)status)));
    }

    public Map<String, Object> checkDatabase(String databaseName) {
        DatabaseMaintenanceServiceImpl.checkDatabaseName(databaseName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = this.databaseManager.connect(databaseName, false);){
            OStorage storage = db.getStorage();
            if (!(storage instanceof OAbstractPaginatedStorage) && !((storage = storage.getUnderlying()) instanceof OAbstractPaginatedStorage)) {
                throw new UnsupportedOperationException("Unknown storage type " + storage.getClass());
            }
            HashMap<String, Object> summary = new HashMap<String, Object>();
            this.log.info("Checking storage for {} database", (Object)databaseName);
            boolean pageCorruption = !((OAbstractPaginatedStorage)storage).check(true, arg_0 -> ((Logger)this.log).info(arg_0));
            summary.put("pageCorruption", pageCorruption);
            this.log.info("Checking indexes for {} database", (Object)databaseName);
            OCheckIndexTool indexTool = new OCheckIndexTool();
            indexTool.setDatabase((ODatabaseDocument)db);
            indexTool.setVerbose(true);
            indexTool.setOutputListener(arg_0 -> ((Logger)this.log).info(arg_0));
            indexTool.run();
            summary.put("indexErrors", indexTool.getTotalErrors());
            this.log.info("Checked {} database: {}", (Object)databaseName, summary);
            return summary;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Map<String, Object> reinstallDatabase(String databaseName) {
        DatabaseMaintenanceServiceImpl.checkDatabaseName(databaseName);
        return this.whenClustered("reinstallDatabase", () -> {
            HashMap<String, Boolean> summary = new HashMap<String, Boolean>();
            this.log.info("Reinstalling {} database with content from cluster", (Object)databaseName);
            boolean reinstalled = this.hazelcastPlugin().installDatabase(true, databaseName, true, false);
            summary.put("reinstalled", reinstalled);
            if (reinstalled) {
                this.log.info("Reinstalled {} database with content from cluster", (Object)databaseName);
            } else {
                this.log.warn("Failed to reinstall {} database with content from cluster", (Object)databaseName);
            }
            return summary;
        });
    }

    private static void checkDatabaseName(String databaseName) {
        Preconditions.checkArgument((boolean)DatabaseInstanceNames.DATABASE_NAMES.contains(databaseName), (String)"Database '%s' does not exist", (Object)databaseName);
    }

    private void whenClustered(String method, Runnable runnable) {
        this.whenClustered(method, () -> {
            runnable.run();
            return null;
        });
    }

    private <T> T whenClustered(String method, Supplier<T> supplier) {
        if (!this.nodeAccess.isClustered()) {
            throw new UnsupportedOperationException("Maintenance method '" + method + "' is only supported in clustered mode");
        }
        return supplier.get();
    }

    private ODistributedConfiguration.ROLES getServerRole(String databaseName) {
        ODistributedServerManager serverManager = ((OServer)this.serverProvider.get()).getDistributedManager();
        ODistributedConfiguration configuration = serverManager.getDatabaseConfiguration(databaseName);
        return configuration.getServerRole(this.nodeAccess.getId());
    }

    private void setServerRole(String databaseName, ODistributedConfiguration.ROLES role) {
        boolean removeOverride = role == ODistributedConfiguration.ROLES.MASTER;
        this.log.info("Updating server role of {} database to {}", (Object)databaseName, (Object)(removeOverride ? "cluster default" : role));
        ODistributedServerManager serverManager = ((OServer)this.serverProvider.get()).getDistributedManager();
        serverManager.executeInDistributedDatabaseLock(databaseName, 0L, null, configuration -> {
            if (removeOverride) {
                ODocument document = configuration.getDocument();
                ODocument servers = (ODocument)document.field("servers");
                if (servers != null && servers.removeField(this.nodeAccess.getId()) != null) {
                    document.field("version", (Object)(configuration.getVersion() + 1));
                }
            } else {
                configuration.setServerRole(this.nodeAccess.getId(), role);
            }
            return null;
        });
        this.log.info("Updated server role of {} database to {}", (Object)databaseName, (Object)(removeOverride ? "cluster default" : role));
    }

    private SharedHazelcastPlugin hazelcastPlugin() {
        return (SharedHazelcastPlugin)((OServer)this.serverProvider.get()).getPluginByClass(SharedHazelcastPlugin.class);
    }

    private int tryRebuildIndex(OIndex<?> index) {
        try {
            index.rebuild();
            return 0;
        }
        catch (Exception e) {
            this.log.warn("Problem rebuilding index {}", (Object)index.getName(), (Object)e);
            return 1;
        }
    }
}

