/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.hazelcast.internal.executor.HazelcastExecutor;
import com.sonatype.nexus.hazelcast.internal.executor.HazelcastJobResult;
import com.sonatype.nexus.hazelcast.internal.orient.DatabaseMaintenanceJob;
import com.sonatype.nexus.hazelcast.internal.orient.DatabaseMaintenanceResourceDoc;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.DatabaseMaintenanceService;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Path(value="/v1/maintenance/{databaseName}")
@Named
@Singleton
public class DatabaseMaintenanceResource
extends ComponentSupport
implements Resource,
DatabaseMaintenanceResourceDoc {
    public static final String RESOURCE_URI = "/v1/maintenance/{databaseName}";
    private final NodeAccess nodeAccess;
    private final DatabaseMaintenanceService maintenanceService;
    private final HazelcastExecutor hazelcastExecutor;

    @Inject
    public DatabaseMaintenanceResource(NodeAccess nodeAccess, DatabaseMaintenanceService maintenanceService, HazelcastExecutor hazelcastExecutor) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.maintenanceService = (DatabaseMaintenanceService)Preconditions.checkNotNull((Object)maintenanceService);
        this.hazelcastExecutor = (HazelcastExecutor)((Object)Preconditions.checkNotNull((Object)((Object)hazelcastExecutor)));
    }

    @Override
    @GET
    @Path(value="role")
    @Produces(value={"text/plain"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public String getRole(@QueryParam(value="nodeId") @Nullable String nodeId, @PathParam(value="databaseName") String databaseName) {
        return this.sendRequest(DatabaseMaintenanceJob.Request.GET_ROLE, nodeId, databaseName, () -> this.maintenanceService.getDatabaseRole(databaseName));
    }

    @Override
    @PUT
    @Path(value="role")
    @Consumes(value={"text/plain"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void setRole(@QueryParam(value="nodeId") @Nullable String nodeId, @PathParam(value="databaseName") String databaseName, String role) {
        this.sendRequest(DatabaseMaintenanceJob.Request.SET_ROLE, nodeId, databaseName, role, () -> this.maintenanceService.setDatabaseRole(databaseName, role));
    }

    @Override
    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public String getStatus(@QueryParam(value="nodeId") @Nullable String nodeId, @PathParam(value="databaseName") String databaseName) {
        return this.sendRequest(DatabaseMaintenanceJob.Request.GET_STATUS, nodeId, databaseName, () -> this.maintenanceService.getDatabaseStatus(databaseName));
    }

    @Override
    @PUT
    @Path(value="status")
    @Consumes(value={"text/plain"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void setStatus(@QueryParam(value="nodeId") @Nullable String nodeId, @PathParam(value="databaseName") String databaseName, String status) {
        this.sendRequest(DatabaseMaintenanceJob.Request.SET_STATUS, nodeId, databaseName, status, () -> this.maintenanceService.setDatabaseStatus(databaseName, status));
    }

    @Override
    @PUT
    @Path(value="check")
    @Produces(value={"application/json"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public Map<String, Object> check(@QueryParam(value="nodeId") @Nullable String nodeId, @PathParam(value="databaseName") String databaseName) {
        return this.sendRequest(DatabaseMaintenanceJob.Request.CHECK, nodeId, databaseName, () -> this.maintenanceService.checkDatabase(databaseName));
    }

    @Override
    @PUT
    @Path(value="reinstall")
    @Produces(value={"application/json"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public Map<String, Object> reinstall(@QueryParam(value="nodeId") @Nullable String nodeId, @PathParam(value="databaseName") String databaseName) {
        return this.sendRequest(DatabaseMaintenanceJob.Request.REINSTALL, nodeId, databaseName, () -> this.maintenanceService.reinstallDatabase(databaseName));
    }

    private <T> T sendRequest(DatabaseMaintenanceJob.Request request, @Nullable String nodeId, String databaseName, Supplier<T> localRequest) {
        return this.sendRequest(request, nodeId, databaseName, null, localRequest);
    }

    private void sendRequest(DatabaseMaintenanceJob.Request request, @Nullable String nodeId, String databaseName, @Nullable String newValue, Runnable localRequest) {
        this.sendRequest(request, nodeId, databaseName, newValue, () -> {
            localRequest.run();
            return null;
        });
    }

    private <T> T sendRequest(DatabaseMaintenanceJob.Request request, @Nullable String nodeId, String databaseName, @Nullable String newValue, Supplier<T> localRequest) {
        T result;
        String description = this.describeRequest(request, nodeId, databaseName, newValue);
        this.log.info("Sending {}", (Object)description);
        try {
            result = this.isLocalRequest(nodeId) ? localRequest.get() : this.sendRemoteRequest(request, nodeId, databaseName, newValue);
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            this.log.warn("Bad request {}", (Object)description, (Object)e);
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, "Bad request " + description + ": " + e);
        }
        catch (Exception e) {
            this.log.warn("Problem sending {}", (Object)description, (Object)e);
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, "Problem sending " + description + ": " + e);
        }
        this.log.info("Sent {} = {}", (Object)description, result);
        return result;
    }

    private boolean isLocalRequest(@Nullable String nodeId) {
        return nodeId == null || nodeId.equals(this.nodeAccess.getId());
    }

    private <T> T sendRemoteRequest(DatabaseMaintenanceJob.Request request, String nodeId, String databaseName, @Nullable String newValue) throws Exception {
        HazelcastJobResult<Object> remoteResult = this.hazelcastExecutor.executeOnNode(nodeId, new DatabaseMaintenanceJob(request, databaseName, newValue));
        if (remoteResult.getError() != null) {
            throw remoteResult.getError();
        }
        return (T)remoteResult.getResult();
    }

    private String describeRequest(DatabaseMaintenanceJob.Request request, @Nullable String nodeId, String databaseName, @Nullable String newValue) {
        boolean localRequest = this.isLocalRequest(nodeId);
        StringBuilder buf = new StringBuilder().append((Object)request);
        if (newValue != null) {
            buf.append('(').append(newValue).append(')');
        }
        buf.append(" maintenance request to ");
        if (localRequest) {
            buf.append("local ");
        }
        buf.append(databaseName).append(" database");
        if (!localRequest) {
            buf.append(" on node ").append(nodeId);
        }
        return buf.toString();
    }
}

