/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.orient;

import com.google.inject.Inject;
import com.sonatype.nexus.hazelcast.internal.executor.HazelcastJob;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.orient.DatabaseMaintenanceService;

@Named
public class DatabaseMaintenanceJob
implements HazelcastJob<Object> {
    private static final long serialVersionUID = -7838585383685357059L;
    private static final String JOB_WAIT_MINUTES_PROP = "nexus.orient.maintenance.jobWaitMinutes";
    private static final int MAX_WAIT_MINUTES_DEFAULT = 5;
    private static final int MAX_WAIT_MINUTES = SystemPropertiesHelper.getInteger((String)"nexus.orient.maintenance.jobWaitMinutes", (int)5);
    private Request request;
    private String databaseName;
    private String newValue;
    private transient DatabaseMaintenanceService maintenanceService;

    public DatabaseMaintenanceJob() {
    }

    public DatabaseMaintenanceJob(Request request, String databaseName, String newValue) {
        this.request = request;
        this.databaseName = databaseName;
        this.newValue = newValue;
    }

    @Inject
    public void setMaintenanceService(DatabaseMaintenanceService maintenanceService) {
        this.maintenanceService = maintenanceService;
    }

    @Override
    public Object call() {
        Object result = null;
        switch (this.request) {
            case GET_ROLE: {
                result = this.maintenanceService.getDatabaseRole(this.databaseName);
                break;
            }
            case SET_ROLE: {
                this.maintenanceService.setDatabaseRole(this.databaseName, this.newValue);
                break;
            }
            case GET_STATUS: {
                result = this.maintenanceService.getDatabaseStatus(this.databaseName);
                break;
            }
            case SET_STATUS: {
                this.maintenanceService.setDatabaseStatus(this.databaseName, this.newValue);
                break;
            }
            case CHECK: {
                result = this.maintenanceService.checkDatabase(this.databaseName);
                break;
            }
            case REINSTALL: {
                this.maintenanceService.reinstallDatabase(this.databaseName);
                break;
            }
            default: {
                result = "Unknown request " + (Object)((Object)this.request);
            }
        }
        return result;
    }

    @Override
    public long getMaxWaitTimeSeconds() {
        return TimeUnit.MINUTES.toSeconds(MAX_WAIT_MINUTES);
    }

    public static enum Request {
        GET_ROLE,
        SET_ROLE,
        GET_STATUS,
        SET_STATUS,
        CHECK,
        REINSTALL;

    }
}

