/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.orient;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.jmx.reflect.ManagedOperation;
import org.sonatype.nexus.orient.DatabaseInstanceNames;
import org.sonatype.nexus.orient.DatabaseMaintenanceService;

@Named
@Singleton
@ManagedObject
public class DatabaseMaintenanceBean
extends ComponentSupport {
    private final DatabaseMaintenanceService maintenanceService;

    @Inject
    public DatabaseMaintenanceBean(DatabaseMaintenanceService maintenanceService) {
        this.maintenanceService = (DatabaseMaintenanceService)Preconditions.checkNotNull((Object)maintenanceService);
    }

    @ManagedAttribute
    public String getDatabaseRole() {
        try {
            return this.maintenanceService.getDatabaseRole("component");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    @ManagedAttribute
    public void setDatabaseRole(String role) {
        DatabaseInstanceNames.DATABASE_NAMES.forEach(db -> this.maintenanceService.setDatabaseRole(db, role));
    }

    @ManagedAttribute
    public String getDatabaseStatus() {
        try {
            return this.maintenanceService.getDatabaseStatus("component");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    @ManagedAttribute
    public void setDatabaseStatus(String status) {
        DatabaseInstanceNames.DATABASE_NAMES.forEach(db -> this.maintenanceService.setDatabaseStatus(db, status));
    }

    @ManagedOperation
    public Map<String, Object> checkDatabase(String databaseName) {
        return this.maintenanceService.checkDatabase(databaseName);
    }

    @ManagedOperation
    public Map<String, Object> reinstallDatabase(String databaseName) {
        return this.maintenanceService.reinstallDatabase(databaseName);
    }
}

