/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.orient;

import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.sonatype.nexus.hazelcast.internal.orient.AdaptiveDistributedConfiguration;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveDistributedStorage
extends ODistributedStorage {
    private static final Logger log;
    @Nullable
    private static final Field distributedConfigurationField;

    static {
        Field _distributedConfigurationField;
        log = LoggerFactory.getLogger(AdaptiveDistributedConfiguration.class);
        try {
            _distributedConfigurationField = ODistributedStorage.class.getDeclaredField("distributedConfiguration");
            _distributedConfigurationField.setAccessible(true);
        }
        catch (Exception | LinkageError e) {
            log.warn("Problem introspecting ODistributedStorage", e);
            _distributedConfigurationField = null;
        }
        distributedConfigurationField = _distributedConfigurationField;
    }

    public AdaptiveDistributedStorage(OServer server, String dbName) {
        super(server, dbName);
    }

    public ODistributedConfiguration getDistributedConfiguration() {
        ODistributedConfiguration config = super.getDistributedConfiguration();
        if (!(config instanceof AdaptiveDistributedConfiguration) && distributedConfigurationField != null) {
            config = new AdaptiveDistributedConfiguration(config.getDocument());
            try {
                distributedConfigurationField.set((Object)this, config);
            }
            catch (Exception | LinkageError e) {
                log.warn("Problem enhancing ODistributedConfiguration", e);
            }
        }
        return config;
    }

    public void setDistributedConfiguration(OModifiableDistributedConfiguration config) {
        super.setDistributedConfiguration(config);
        this.getDistributedConfiguration();
    }
}

