/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.io;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.listener.EntryExpiredListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicates;
import com.sonatype.nexus.hazelcast.internal.io.DistributedCooperatingFuture;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.io.CooperatingFuture;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactorySupport;
import org.sonatype.nexus.common.io.ScopedCooperationFactorySupport;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.node.NodeRemovedEvent;

@Named(value="hazelcast")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class HazelcastCooperationFactory
extends ScopedCooperationFactorySupport
implements EventAware {
    private static final String DISTRIBUTED_KEYS_MAP_NAME = "nexus:cooperating-keys";
    private static final String COMPLETED_TOKEN = "completed";
    private static final int CHECK_PERIOD_MILLIS = 500;
    private final NodeAccess nodeAccess;
    private final Provider<HazelcastInstance> hazelcastProvider;
    private final boolean clusteredCooperationEnabled;
    private final Time clusteredCooperationLag;
    private final ConcurrentMap<String, CooperatingFuture<?>> localCache = new ConcurrentHashMap();
    private IMap<String, String> distributedKeys;

    @Inject
    public HazelcastCooperationFactory(NodeAccess nodeAccess, Provider<HazelcastInstance> hazelcastProvider, @Named(value="${nexus.clustered.cooperation.enabled:-true}") boolean clusteredCooperationEnabled, @Named(value="${nexus.clustered.cooperation.lag:-10s}") Time clusteredCooperationLag) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
        this.clusteredCooperationEnabled = clusteredCooperationEnabled;
        this.clusteredCooperationLag = (Time)Preconditions.checkNotNull((Object)clusteredCooperationLag);
    }

    protected void doStart() {
        if (this.clusteredCooperationEnabled && this.nodeAccess.isClustered()) {
            this.distributedKeys = ((HazelcastInstance)this.hazelcastProvider.get()).getMap(DISTRIBUTED_KEYS_MAP_NAME);
            this.distributedKeys.addEntryListener((MapListener)new RemoteKeyWatcher(), false);
        }
    }

    protected <T> CooperatingFuture<T> createFuture(String requestKey, CooperationFactorySupport.Config config) {
        return new DistributedCooperatingFuture(requestKey, config);
    }

    protected <T> CooperatingFuture<T> beginCooperation(String scopedKey, CooperatingFuture<T> myFuture) {
        String token;
        CooperatingFuture<T> theirFuture = this.localCache.putIfAbsent(scopedKey, myFuture);
        if (theirFuture == null && this.distributedKeys != null && (token = (String)this.distributedKeys.putIfAbsent((Object)scopedKey, (Object)this.nodeAccess.getId())) != null) {
            theirFuture = myFuture;
            if (token.equals(COMPLETED_TOKEN)) {
                ((DistributedCooperatingFuture)myFuture).remoteCompleted();
            }
        }
        return theirFuture;
    }

    protected <T> void endCooperation(String scopedKey, CooperatingFuture<T> future) {
        if (this.distributedKeys != null) {
            if (this.clusteredCooperationLag.value() > 0L && !future.isCompletedExceptionally()) {
                this.distributedKeys.set((Object)scopedKey, (Object)COMPLETED_TOKEN, this.clusteredCooperationLag.value(), this.clusteredCooperationLag.unit());
            } else {
                this.distributedKeys.remove((Object)scopedKey);
            }
        } else {
            this.localCache.remove(scopedKey, future);
        }
    }

    protected Stream<CooperatingFuture<?>> streamFutures(String scope) {
        return this.localCache.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(scope)).map(Map.Entry::getValue);
    }

    protected <T> T join(Cooperation.IOCheck<T> request) throws IOException {
        int frequency = this.clusteredCooperationLag.toMillisI() / 500;
        if (frequency <= 1) {
            return (T)request.check();
        }
        int i = 0;
        while (i < frequency) {
            Object value = request.check();
            if (value != null) {
                return (T)value;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        return null;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onNodeRemoved(NodeRemovedEvent event) {
        if (this.distributedKeys != null) {
            this.distributedKeys.removeAll(Predicates.equal((String)"this", (Comparable)((Object)event.getNodeId())));
        }
    }

    private class RemoteKeyWatcher
    implements EntryUpdatedListener<String, String>,
    EntryExpiredListener<String, String>,
    EntryRemovedListener<String, String> {
        private RemoteKeyWatcher() {
        }

        public void entryUpdated(EntryEvent<String, String> event) {
            CooperatingFuture future = (CooperatingFuture)HazelcastCooperationFactory.this.localCache.get(event.getKey());
            if (future != null && !future.isDone()) {
                ((DistributedCooperatingFuture)future).remoteCompleted();
            }
        }

        public void entryExpired(EntryEvent<String, String> event) {
            HazelcastCooperationFactory.this.localCache.remove(event.getKey());
        }

        public void entryRemoved(EntryEvent<String, String> event) {
            this.entryUpdated(event);
            this.entryExpired(event);
        }
    }
}

