/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.io;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.sonatype.nexus.common.io.CooperatingFuture;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactorySupport;
import org.sonatype.nexus.orient.ReplicationModeOverrides;

class DistributedCooperatingFuture<T>
extends CooperatingFuture<T> {
    private final AtomicReference<Thread> headWaiter = new AtomicReference();
    private volatile boolean localCompleting;
    private volatile boolean remoteCompletion;

    DistributedCooperatingFuture(String requestKey, CooperationFactorySupport.Config config) {
        super(requestKey, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T performCall(Cooperation.IOCall<T> request, boolean failover) throws IOException {
        this.localCompleting = true;
        if (this.remoteCompletion) {
            DistributedCooperatingFuture distributedCooperatingFuture = this;
            synchronized (distributedCooperatingFuture) {
                Thread.interrupted();
            }
        }
        ReplicationModeOverrides.dontWaitForReplicationResults();
        try {
            Object object = super.performCall(request, failover);
            return (T)object;
        }
        finally {
            ReplicationModeOverrides.clearReplicationModeOverrides();
        }
    }

    protected T waitForCall(Cooperation.IOCall<T> request, Duration timeout, boolean failover) throws InterruptedException, ExecutionException, IOException {
        if (this.localCompleting) {
            return (T)super.waitForCall(request, timeout, failover);
        }
        return this.waitForRemote(request, timeout, failover);
    }

    private T waitForRemote(Cooperation.IOCall<T> request, Duration timeout, boolean failover) throws InterruptedException, ExecutionException, IOException {
        block3: {
            boolean isHeadWaiter = this.headWaiter.compareAndSet(null, Thread.currentThread());
            if (!isHeadWaiter || !this.remoteCompletion) {
                try {
                    return (T)super.waitForCall(request, timeout, failover);
                }
                catch (InterruptedException e) {
                    if (isHeadWaiter && this.remoteCompletion) break block3;
                    throw e;
                }
            }
        }
        return this.performCall(request, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remoteCompleted() {
        log.debug("Remote completed {}", (Object)this);
        DistributedCooperatingFuture distributedCooperatingFuture = this;
        synchronized (distributedCooperatingFuture) {
            this.remoteCompletion = true;
            if (!this.localCompleting && this.headWaiter.get() != null) {
                this.headWaiter.get().interrupt();
            }
        }
    }
}

