/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.executor;

import com.google.inject.Inject;
import com.sonatype.nexus.hazelcast.internal.executor.HazelcastJob;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.supportzip.SupportZipGenerator;

@Named
public class SupportZipHazelcastJob
implements HazelcastJob<SupportZipGenerator.Result> {
    private static final long serialVersionUID = 3894929029290791071L;
    private static final String JOB_WAIT_MINUTES_PROP = "nexus.supportzip.ha.job.wait.minutes";
    private static final int MAX_WAIT_MINUTES_DEFAULT = 5;
    private static final int MAX_WAIT_MINUTES = SystemPropertiesHelper.getInteger((String)"nexus.supportzip.ha.job.wait.minutes", (int)5);
    private SupportZipGenerator.Request request;
    private transient SupportZipGenerator generator;
    private transient NodeAccess nodeAccess;

    public SupportZipHazelcastJob() {
    }

    public SupportZipHazelcastJob(SupportZipGenerator.Request request) {
        this.request = request;
    }

    @Inject
    public void setGenerator(SupportZipGenerator generator) {
        this.generator = generator;
    }

    @Inject
    public void setNodeAccess(NodeAccess nodeAccess) {
        this.nodeAccess = nodeAccess;
    }

    @Override
    public SupportZipGenerator.Result call() {
        return this.generator.generate(this.request, String.valueOf((String)this.nodeAccess.getMemberAliases().get(this.nodeAccess.getId())) + "-support-zip-");
    }

    @Override
    public long getMaxWaitTimeSeconds() {
        return TimeUnit.MINUTES.toSeconds(MAX_WAIT_MINUTES);
    }
}

