/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.executor;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class HazelcastJobResult<T> {
    private String nodeId;
    private T result;
    private Exception error;

    private HazelcastJobResult(String nodeId, T result) {
        this(nodeId, result, null);
    }

    private HazelcastJobResult(String nodeId, Exception error) {
        this(nodeId, null, error);
    }

    private HazelcastJobResult(String nodeId, @Nullable T result, @Nullable Exception error) {
        this.nodeId = nodeId;
        this.result = result;
        this.error = error;
    }

    static <T> HazelcastJobResult<T> success(String nodeId, T result) {
        Preconditions.checkNotNull(result, (Object)"Success requires result value");
        return new HazelcastJobResult<T>(nodeId, result);
    }

    static <T> HazelcastJobResult<T> failure(String nodeId, @Nullable Exception error) {
        return new HazelcastJobResult<T>(nodeId, error);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @Nullable
    public T getResult() {
        return this.result;
    }

    @Nullable
    public Exception getError() {
        return this.error;
    }
}

