/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.executor;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.sonatype.nexus.hazelcast.internal.HazelcastNodeAccess;
import com.sonatype.nexus.hazelcast.internal.executor.HazelcastJob;
import com.sonatype.nexus.hazelcast.internal.executor.HazelcastJobResult;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.goodies.common.ComponentSupport;

@Singleton
@Named
public class HazelcastExecutor
extends ComponentSupport {
    private static final String TASK_EXECUTOR_NAME = "nexus-cluster-executor";
    private final Provider<HazelcastInstance> instanceProvider;

    @Inject
    public HazelcastExecutor(Provider<HazelcastInstance> instanceProvider) {
        this.instanceProvider = (Provider)Preconditions.checkNotNull(instanceProvider);
    }

    public <T> List<HazelcastJobResult<T>> executeOnAllNodes(HazelcastJob<T> hazelcastJob) {
        String taskName = hazelcastJob.getClass().getSimpleName();
        long maxWaitSeconds = hazelcastJob.getMaxWaitTimeSeconds();
        IExecutorService executorService = ((HazelcastInstance)this.instanceProvider.get()).getExecutorService(TASK_EXECUTOR_NAME);
        return executorService.submitToAllMembers(hazelcastJob).entrySet().parallelStream().map(entry -> {
            String nodeId = HazelcastNodeAccess.getNodeId((Member)entry.getKey());
            Future future = (Future)entry.getValue();
            return this.waitForResult(nodeId, taskName, maxWaitSeconds, future);
        }).collect(Collectors.toList());
    }

    public <T> HazelcastJobResult<T> executeOnNode(String nodeId, HazelcastJob<T> hazelcastJob) {
        Optional<Member> targetMember = ((HazelcastInstance)this.instanceProvider.get()).getCluster().getMembers().stream().filter(m -> nodeId.equals(HazelcastNodeAccess.getNodeId(m))).findFirst();
        Preconditions.checkArgument((boolean)targetMember.isPresent(), (String)"Node '%s' is not part of the cluster", (Object)nodeId);
        String taskName = hazelcastJob.getClass().getSimpleName();
        long maxWaitSeconds = hazelcastJob.getMaxWaitTimeSeconds();
        IExecutorService executorService = ((HazelcastInstance)this.instanceProvider.get()).getExecutorService(TASK_EXECUTOR_NAME);
        Future future = executorService.submitToMember(hazelcastJob, targetMember.get());
        return this.waitForResult(nodeId, taskName, maxWaitSeconds, future);
    }

    private <T> HazelcastJobResult<T> waitForResult(String nodeId, String taskName, long maxWaitSeconds, Future<T> future) {
        try {
            return HazelcastJobResult.success(nodeId, future.get(maxWaitSeconds, TimeUnit.SECONDS));
        }
        catch (TimeoutException e) {
            this.log.error("Task: {} failed to complete in {}s on node: {}", new Object[]{taskName, maxWaitSeconds, nodeId});
            future.cancel(true);
            return HazelcastJobResult.failure(nodeId, e);
        }
        catch (Exception e) {
            this.log.error("Unable to complete task: {} on node: {}", new Object[]{taskName, nodeId, e});
            future.cancel(true);
            return HazelcastJobResult.failure(nodeId, e);
        }
    }
}

