/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.commands;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.sonatype.nexus.orient.DatabaseInstanceNames;
import org.sonatype.nexus.orient.DatabaseMaintenanceService;

@Named
@Command(name="databaseStatus", scope="nexus", description="Queries or overrides database statuses")
public class DatabaseStatusAction
implements Action {
    private final DatabaseMaintenanceService maintenanceService;
    @Argument(description="The status to reset to")
    private ODistributedServerManager.DB_STATUS status;

    @Inject
    public DatabaseStatusAction(DatabaseMaintenanceService maintenanceService) {
        this.maintenanceService = (DatabaseMaintenanceService)Preconditions.checkNotNull((Object)maintenanceService);
    }

    public Object execute() throws Exception {
        if (this.status != null) {
            DatabaseInstanceNames.DATABASE_NAMES.forEach(db -> this.maintenanceService.setDatabaseStatus(db, this.status.name()));
        } else {
            this.maintenanceService.logServersStatus();
        }
        return null;
    }
}

