/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.commands;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.sonatype.nexus.orient.DatabaseInstanceNames;
import org.sonatype.nexus.orient.DatabaseMaintenanceService;

@Named
@Command(name="databaseRole", scope="nexus", description="Queries or overrides database roles")
public class DatabaseRoleAction
implements Action {
    private final DatabaseMaintenanceService maintenanceService;
    @Argument(description="The role to reset to")
    private ODistributedConfiguration.ROLES role;

    @Inject
    public DatabaseRoleAction(DatabaseMaintenanceService maintenanceService) {
        this.maintenanceService = (DatabaseMaintenanceService)Preconditions.checkNotNull((Object)maintenanceService);
    }

    public Object execute() throws Exception {
        if (this.role != null) {
            DatabaseInstanceNames.DATABASE_NAMES.forEach(db -> this.maintenanceService.setDatabaseRole(db, this.role.name()));
        } else {
            this.maintenanceService.logServersStatus();
        }
        return null;
    }
}

