/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.commands;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.sonatype.nexus.orient.DatabaseMaintenanceService;
import org.sonatype.nexus.orient.DatabaseServer;
import org.sonatype.nexus.orient.quorum.DatabaseQuorumStatus;

@Named
@Command(name="quorum", scope="nexus", description="Check or set database read and write quorum values")
public class DatabaseQuorumAction
implements Action {
    private final DatabaseMaintenanceService databaseMaintenanceService;
    private final DatabaseServer databaseServer;
    @Option(name="-r", aliases={"--reset"}, description="specify when updating quorum value")
    private boolean reset = false;

    @Inject
    public DatabaseQuorumAction(DatabaseMaintenanceService databaseMaintenanceService, DatabaseServer databaseServer) {
        this.databaseMaintenanceService = (DatabaseMaintenanceService)Preconditions.checkNotNull((Object)databaseMaintenanceService);
        this.databaseServer = (DatabaseServer)Preconditions.checkNotNull((Object)databaseServer);
    }

    public Object execute() throws Exception {
        if (this.reset) {
            System.out.format("resetting write quorum on databases\n", new Object[0]);
            this.databaseMaintenanceService.resetWriteQuorum();
        } else {
            this.databaseServer.databases().forEach(this::logQuorumStatus);
        }
        return null;
    }

    private void logQuorumStatus(String db) {
        DatabaseQuorumStatus status = this.databaseMaintenanceService.getQuorumStatus(db);
        System.out.format("write quorum value: %d, quorum present: %b, on database: %s%n", status.getMinimumForQuorum(), status.isQuorumPresent(), db);
        System.out.format("\tavailable members: %s%n", String.join((CharSequence)",", status.getMembers()));
        System.out.format("\tall configured members: %s%n", String.join((CharSequence)",", status.getAllConfiguredServers()));
    }
}

