/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.cluster;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class ClusterLogTaskInitializer
extends ComponentSupport
implements Lifecycle {
    private static final String DEFAULT_CRON_EXPRESSION = "0 */5 * ? * * *";
    private final NodeAccess nodeAccess;
    private final TaskScheduler taskScheduler;
    private final boolean enabled;

    @Inject
    public ClusterLogTaskInitializer(NodeAccess nodeAccess, TaskScheduler taskScheduler, @Named(value="${nexus.log.cluster.enabled:-false}") boolean enabled) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.enabled = enabled;
    }

    public void start() {
        this.log.info("Starting table count logging");
        List<TaskInfo> loggingTasks = this.taskScheduler.listsTasks().stream().filter(ti -> "cluster.periodicLogging".equals(ti.getTypeId())).collect(Collectors.toList());
        if (this.enabled && this.nodeAccess.isClustered() && loggingTasks.isEmpty()) {
            this.log.debug("Table count logging enabled");
            TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("cluster.periodicLogging");
            Cron cron = this.taskScheduler.getScheduleFactory().cron(new Date(), DEFAULT_CRON_EXPRESSION);
            TaskInfo taskInfo = this.taskScheduler.scheduleTask(configuration, (Schedule)cron);
            this.log.debug("New task {} created", (Object)taskInfo.getId());
        } else if (!this.enabled) {
            this.log.debug("Table count logging disabled");
            this.removeTasks(loggingTasks);
        }
    }

    private void removeTasks(List<TaskInfo> loggingTasks) {
        loggingTasks.forEach(taskInfo -> {
            this.log.debug(TaskLoggingMarkers.CLUSTER_LOG_ONLY, "Removing task {}", (Object)taskInfo.getId());
            taskInfo.remove();
        });
    }

    public void stop() {
    }
}

