/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.cluster;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseMaintenanceService;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class ClusterLogTask
extends TaskSupport {
    public static final String SEPARATOR = "+--------------------------------+-----------------+\n";
    private final List<Provider<DatabaseInstance>> databases;
    private final Provider<DatabaseMaintenanceService> databaseMaintenanceServiceProvider;

    @Inject
    public ClusterLogTask(@Named(value="config") Provider<DatabaseInstance> configDb, @Named(value="component") Provider<DatabaseInstance> componentDb, Provider<DatabaseMaintenanceService> databaseMaintenanceServiceProvider) {
        super(false);
        this.databases = ImmutableList.of((Object)((Provider)Preconditions.checkNotNull(configDb)), (Object)((Provider)Preconditions.checkNotNull(componentDb)));
        this.databaseMaintenanceServiceProvider = (Provider)Preconditions.checkNotNull(databaseMaintenanceServiceProvider);
    }

    protected Object execute() {
        if (this.log.isInfoEnabled(TaskLoggingMarkers.CLUSTER_LOG_ONLY)) {
            this.databases.stream().map(Provider::get).forEach(this::logTable);
            this.logHaStatus();
            this.logProfilerStatistics();
        } else {
            this.log.debug("Logging for cluster information is not enabled by logging level");
        }
        return null;
    }

    private void logTable(DatabaseInstance instance) {
        StringBuilder table = new StringBuilder();
        table.append("\n").append(SEPARATOR).append(String.format("| %-48s |%n", String.valueOf(instance.getName()) + " Database")).append(SEPARATOR).append("| Table Name                     | Count           |\n").append(SEPARATOR);
        Throwable throwable = null;
        Object var4_5 = null;
        try (ODatabaseDocumentTx db = instance.acquire();){
            db.getMetadata().getSchema().getClasses().stream().sorted(Comparator.comparing(OClass::getName, String.CASE_INSENSITIVE_ORDER)).map(c -> String.format("| %-30s | %-15d |%n", c.getName(), c.count())).forEach(table::append);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        table.append(SEPARATOR);
        this.log.info(TaskLoggingMarkers.CLUSTER_LOG_ONLY, "\n{}", (Object)table);
    }

    private void logHaStatus() {
        this.log.info(TaskLoggingMarkers.CLUSTER_LOG_ONLY, ((DatabaseMaintenanceService)this.databaseMaintenanceServiceProvider.get()).fullServerStatus());
    }

    private void logProfilerStatistics() {
        String statisticsString = ((DatabaseMaintenanceService)this.databaseMaintenanceServiceProvider.get()).profilerStatistics().entrySet().stream().map(e -> "  " + (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining("\n"));
        this.log.info(TaskLoggingMarkers.CLUSTER_LOG_ONLY, "Profiler statistics:\n" + statisticsString);
    }

    public String getMessage() {
        return "Log cluster information";
    }
}

