/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.cluster;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.node.NodeAccess;

@Named(value="Cluster Size")
@Singleton
public class ClusterHealthCheck
extends HealthCheck {
    private final int expectedClusterSize;
    private final NodeAccess nodeAccess;

    @Inject
    public ClusterHealthCheck(@Named(value="${nexus.healthcheck.cluster.size:-3}") int expectedClusterSize, NodeAccess nodeAccess) {
        this.expectedClusterSize = expectedClusterSize;
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    protected HealthCheck.Result check() {
        if (this.nodeAccess.isClustered()) {
            int clusterSize = this.getClusterSize();
            String message = this.getMessage(clusterSize);
            if (clusterSize != this.expectedClusterSize) {
                return HealthCheck.Result.unhealthy((String)message);
            }
            return HealthCheck.Result.healthy();
        }
        return HealthCheck.Result.healthy();
    }

    private int getClusterSize() {
        return this.nodeAccess.getMemberIds().size();
    }

    private String getMessage(int clusterSize) {
        return String.format("Clusters must have %s nodes: %s detected", this.expectedClusterSize, clusterSize);
    }
}

