/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.hazelcast.config.Config;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.sonatype.nexus.hazelcast.HazelcastConfigCustomizer;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.node.NodeAddedEvent;
import org.sonatype.nexus.common.node.NodeConfiguration;
import org.sonatype.nexus.common.node.NodeConfigurationSource;
import org.sonatype.nexus.common.node.NodeMergedEvent;
import org.sonatype.nexus.common.node.NodeRemovedEvent;
import org.sonatype.nexus.common.node.orient.OrientNodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named(value="hazelcast")
@Priority(value=0x7FFFFFFF)
@Singleton
public class HazelcastNodeAccess
extends StateGuardLifecycleSupport
implements OrientNodeAccess,
HazelcastConfigCustomizer,
InitialMembershipListener,
LifecycleListener {
    private static final String NODE_ID = "node.identity";
    private final OrientNodeAccess localNodeAccess;
    private final EventManager eventManager;
    private final Provider<NodeConfigurationSource> nodeConfigurationSource;
    private final Set<String> memberIds;
    private volatile String oldestMemberId;

    @Inject
    public HazelcastNodeAccess(@Named(value="local") OrientNodeAccess localNodeAccess, EventManager eventManager, Provider<NodeConfigurationSource> nodeConfigurationSource) {
        this.localNodeAccess = (OrientNodeAccess)Preconditions.checkNotNull((Object)localNodeAccess);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.nodeConfigurationSource = nodeConfigurationSource;
        this.memberIds = Collections.synchronizedSet(new HashSet());
    }

    public static String getNodeId(Member member) {
        return member.getStringAttribute(NODE_ID);
    }

    @Override
    public void apply(Config config) {
        config.getMemberAttributeConfig().setStringAttribute(NODE_ID, this.getId());
        config.addListenerConfig(new ListenerConfig((EventListener)((Object)this)));
    }

    protected void doStart() throws Exception {
        this.localNodeAccess.start();
        this.memberIds.add(this.getId());
        this.oldestMemberId = this.getId();
    }

    protected void doStop() throws Exception {
        this.localNodeAccess.stop();
    }

    public Certificate getCertificate() {
        return this.localNodeAccess.getCertificate();
    }

    public String getFingerprint() {
        return this.localNodeAccess.getFingerprint();
    }

    public String getId() {
        return this.localNodeAccess.getId();
    }

    public String getClusterId() {
        return this.getId();
    }

    public boolean isClustered() {
        return true;
    }

    @Guarded(by={"STARTED"})
    public Set<String> getMemberIds() {
        return ImmutableSet.copyOf(this.memberIds);
    }

    @Guarded(by={"STARTED"})
    public Map<String, String> getMemberAliases() {
        return (Map)this.getMemberIds().stream().collect(Collectors.collectingAndThen(Collectors.toMap(Function.identity(), key -> ((NodeConfigurationSource)this.nodeConfigurationSource.get()).getById(key.toString()).map(NodeConfiguration::getFriendlyNodeName).orElse(key.toString())), ImmutableMap::copyOf));
    }

    public boolean isOldestNode() {
        return this.getId().equals(this.oldestMemberId);
    }

    public void init(InitialMembershipEvent event) {
        this.updateOldestMember(event.getCluster());
        for (Member member : event.getMembers()) {
            this.memberIds.add(HazelcastNodeAccess.getNodeId(member));
        }
    }

    public void memberAdded(MembershipEvent event) {
        this.updateOldestMember(event.getCluster());
        String nodeId = HazelcastNodeAccess.getNodeId(event.getMember());
        if (this.memberIds.add(nodeId)) {
            this.eventManager.post((Object)new NodeAddedEvent(nodeId));
        }
    }

    public void memberRemoved(MembershipEvent event) {
        this.updateOldestMember(event.getCluster());
        String nodeId = HazelcastNodeAccess.getNodeId(event.getMember());
        if (this.memberIds.remove(nodeId)) {
            this.eventManager.post((Object)new NodeRemovedEvent(nodeId));
        }
    }

    private void updateOldestMember(Cluster cluster) {
        this.oldestMemberId = HazelcastNodeAccess.getNodeId((Member)cluster.getMembers().iterator().next());
    }

    public void memberAttributeChanged(MemberAttributeEvent event) {
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "id='" + this.getId() + '\'' + '}';
    }

    public void stateChanged(LifecycleEvent event) {
        LifecycleEvent.LifecycleState state = event.getState();
        if (state == LifecycleEvent.LifecycleState.MERGED) {
            this.eventManager.post((Object)new NodeMergedEvent());
        }
    }
}

