/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

public abstract class HazelcastDistributorSupport
extends StateGuardLifecycleSupport {
    private final NodeAccess nodeAccess;
    private final ThreadLocal<Boolean> remote = new ThreadLocal();
    private boolean enabled;

    protected HazelcastDistributorSupport(NodeAccess nodeAccess) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    protected NodeAccess getNodeAccess() {
        return this.nodeAccess;
    }

    protected boolean isClustered() {
        return this.enabled;
    }

    protected void doStart() throws Exception {
        this.enabled = this.nodeAccess.isClustered();
        if (this.enabled) {
            this.log.debug("Enabling clustered operation");
            this.doStartCluster();
        }
    }

    protected abstract void doStartCluster() throws Exception;

    protected void doStop() throws Exception {
        if (this.enabled) {
            this.log.debug("Disabling clustered operation");
            this.doStopCluster();
            this.enabled = false;
        }
    }

    protected abstract void doStopCluster() throws Exception;

    protected void runAsRemote(Runnable action) {
        this.remote.set(true);
        try {
            action.run();
        }
        finally {
            this.remote.remove();
        }
    }

    protected boolean isRunningAsRemote() {
        return Boolean.TRUE.equals(this.remote.get());
    }
}

