/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal;

import com.google.common.base.Preconditions;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.HazelcastInstance;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.BindAsLifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;

@Named(value="hazelcast")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
public class HazelcastCacheManagerProvider
extends LifecycleSupport
implements Provider<CacheManager> {
    private final Provider<HazelcastInstance> hazelcastInstance;
    private volatile CacheManager cacheManager;

    @Inject
    public HazelcastCacheManagerProvider(Provider<HazelcastInstance> hazelcastInstance) {
        this.hazelcastInstance = (Provider)Preconditions.checkNotNull(hazelcastInstance);
    }

    public synchronized CacheManager get() {
        Preconditions.checkState((!this.isStopped() ? 1 : 0) != 0, (Object)"Cache-manager destroyed");
        if (this.cacheManager == null) {
            HazelcastServerCachingProvider cachingProvider = new HazelcastServerCachingProvider();
            this.cacheManager = new HazelcastServerCacheManager(cachingProvider, (HazelcastInstance)this.hazelcastInstance.get(), null, null, null){

                protected <K, V, C extends Configuration<K, V>> CacheConfig<K, V> createCacheConfig(String cacheName, C configuration) {
                    return new CacheConfigWrapper(super.createCacheConfig(cacheName, configuration), this.getHazelcastInstance().getConfig().getClassLoader());
                }
            };
        }
        return this.cacheManager;
    }

    protected void doStop() {
        if (this.cacheManager != null) {
            this.cacheManager.close();
            this.log.info("Cache-manager closed");
            this.cacheManager = null;
        }
    }

    @Named
    private static class BindAsLifecycle
    extends BindAsLifecycleSupport<HazelcastCacheManagerProvider> {
        private BindAsLifecycle() {
        }
    }

    private static class CacheConfigWrapper<K, V>
    extends CacheConfig<K, V> {
        public CacheConfigWrapper(CacheConfig<K, V> config, ClassLoader classLoader) {
            super(config);
            this.setClassLoader(classLoader);
        }
    }
}

