/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.hazelcast.config.Config;
import com.hazelcast.core.ManagedContext;
import com.sonatype.nexus.hazelcast.HazelcastConfigCustomizer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class GuiceManagedContext
extends ComponentSupport
implements ManagedContext,
HazelcastConfigCustomizer {
    private final Injector injector;

    @Inject
    public GuiceManagedContext(Injector injector) {
        this.injector = (Injector)Preconditions.checkNotNull((Object)injector);
    }

    public Object initialize(Object object) {
        if (object != null) {
            this.injector.injectMembers(object);
        }
        return object;
    }

    @Override
    public void apply(Config config) {
        this.log.debug("Replacing managed context of {} with GuiceManagedContext", (Object)config.getManagedContext());
        config.setManagedContext((ManagedContext)this);
    }
}

