/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.common.wonderland.DownloadService;

@Named(value="blobstore")
@Priority(value=0x7FFFFFFF)
@Singleton
public class BlobStoreDownloadServiceImpl
extends ComponentSupport
implements DownloadService {
    private static final String DOWNLOAD_SERVICE_BLOB_CREATOR = "nexus-blobstore-download-service";
    private static final String DOWNLOAD_SERVICE_BLOB_PREFIX = "nexus-blobstore-download-service";
    private final DownloadService defaultDownloadService;
    private final NodeAccess nodeAccess;
    private final Provider<BlobStoreManager> blobStoreManagerProvider;
    private final Provider<AuthTicketService> authTickets;

    @Inject
    public BlobStoreDownloadServiceImpl(@Named(value="default") DownloadService defaultDownloadService, NodeAccess nodeAccess, Provider<BlobStoreManager> blobStoreManagerProvider, Provider<AuthTicketService> authTicketService) {
        this.defaultDownloadService = (DownloadService)Preconditions.checkNotNull((Object)defaultDownloadService);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.blobStoreManagerProvider = (Provider)Preconditions.checkNotNull(blobStoreManagerProvider);
        this.authTickets = (Provider)Preconditions.checkNotNull(authTicketService);
    }

    public DownloadService.Download get(String name, String authTicket) throws IOException {
        if (!this.nodeAccess.isClustered()) {
            return this.defaultDownloadService.get(name, authTicket);
        }
        Iterator blobStores = ((BlobStoreManager)this.blobStoreManagerProvider.get()).browse().iterator();
        if (!blobStores.hasNext()) {
            this.log.warn("No blob store exists for the cluster. Downloading {} from the local downloads directory instead", (Object)name);
            return this.defaultDownloadService.get(name, authTicket);
        }
        this.log.info("Download: {}", (Object)name);
        if (!((AuthTicketService)this.authTickets.get()).redeemTicket(authTicket)) {
            throw new IllegalArgumentException("Invalid authentication ticket");
        }
        BlobStore blobStore = (BlobStore)blobStores.next();
        Blob blob = blobStore.getDirectPathBlobIdStream("nexus-blobstore-download-service").map(arg_0 -> ((BlobStore)blobStore).get(arg_0)).filter(b -> ((String)b.getHeaders().get("BlobStore.blob-name")).equals(String.format("%s/%s", "nexus-blobstore-download-service", name))).findAny().orElse(null);
        if (blob != null) {
            return new DownloadService.Download(blob.getMetrics().getContentSize(), blob.getInputStream());
        }
        return null;
    }

    public String move(File source, String name) throws IOException {
        if (!this.nodeAccess.isClustered()) {
            return this.defaultDownloadService.move(source, name);
        }
        Iterator blobStores = ((BlobStoreManager)this.blobStoreManagerProvider.get()).browse().iterator();
        if (!blobStores.hasNext()) {
            this.log.warn("No blob store exists for the cluster. Moving {} to the local downloads directory instead", (Object)name);
            return this.defaultDownloadService.move(source, name);
        }
        this.log.info("Move: {}", (Object)name);
        BlobStore blobStore = (BlobStore)blobStores.next();
        String blobStoreName = blobStore.getBlobStoreConfiguration().getName();
        ImmutableMap headers = ImmutableMap.of((Object)"BlobStore.created-by", (Object)"nexus-blobstore-download-service", (Object)"BlobStore.blob-name", (Object)String.format("%s/%s", "nexus-blobstore-download-service", name), (Object)"BlobStore.direct-path", (Object)"true");
        Throwable throwable = null;
        Object var8_9 = null;
        try (FileInputStream input = new FileInputStream(source);){
            blobStore.create((InputStream)input, (Map)headers);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Files.delete(source.toPath());
        return String.format("$blobstore$/%s/%s", blobStoreName, name);
    }

    public String uniqueName(String prefix) {
        return this.defaultDownloadService.uniqueName(prefix);
    }
}

