/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.api;

import com.sonatype.nexus.hazelcast.api.NodeSupportZipXO;
import com.sonatype.nexus.hazelcast.api.NodeXO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.supportzip.SupportZipGenerator;

@Api(value="nodes")
public interface NodesResourceDoc {
    @GET
    @ApiOperation(value="Get HA-C nodes")
    public List<NodeXO> get();

    @PUT
    @ApiOperation(value="Update existing HA-C node", notes="Can only modify friendlyName for existing nodes.")
    @ApiResponses(value={@ApiResponse(code=400, message="HA-C is not enabled"), @ApiResponse(code=404, message="No matching node found for nodeIdentity")})
    public NodeXO update(@NotNull @Valid NodeXO var1);

    @ApiOperation(value="Requests support zips from all nodes", notes="This request will propagate to all nodes in the cluster.")
    @ApiResponses(value={@ApiResponse(code=200, message="Support zip results created")})
    public List<NodeSupportZipXO> createSupportZips(SupportZipGenerator.Request var1);

    @ApiOperation(value="Retrieve a node's generated support zip")
    @ApiResponses(value={@ApiResponse(code=200, message="Downloads the specified support zip"), @ApiResponse(code=404, message="Specified support zip not found"), @ApiResponse(code=500, message="Error occurred while retrieving the support zip")})
    public Response downloadSupportZip(@ApiParam(value="The ID of the support zip") String var1);
}

