/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.api;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.sonatype.nexus.hazelcast.api.NodeSupportZipXO;
import com.sonatype.nexus.hazelcast.api.NodeXO;
import com.sonatype.nexus.hazelcast.api.NodesResourceDoc;
import com.sonatype.nexus.hazelcast.internal.HazelcastNodeAccess;
import com.sonatype.nexus.hazelcast.internal.executor.HazelcastExecutor;
import com.sonatype.nexus.hazelcast.internal.executor.HazelcastJobResult;
import com.sonatype.nexus.hazelcast.internal.executor.SupportZipHazelcastJob;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.node.NodeConfigurationSource;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.common.wonderland.DownloadService;
import org.sonatype.nexus.rest.NotCacheable;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.supportzip.SupportZipGenerator;

@Named
@Singleton
@Path(value="/v1/nodes")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NodesResource
extends ComponentSupport
implements Resource,
NodesResourceDoc {
    public static final String RESOURCE_URI = "/v1/nodes";
    private static final String SUPPORT_ZIP_DOWNLOAD_PATH = "/supportzipdownload";
    private final Provider<HazelcastInstance> hazelcastProvider;
    private final NodeAccess nodeAccess;
    private final NodeConfigurationSource nodeConfigurationSource;
    private final HazelcastExecutor hazelcastExecutor;
    private final DownloadService downloadService;
    private final AuthTicketService authTicketService;

    @Inject
    public NodesResource(Provider<HazelcastInstance> hazelcastProvider, NodeAccess nodeAccess, NodeConfigurationSource nodeConfigurationSource, HazelcastExecutor hazelcastExecutor, DownloadService downloadService, AuthTicketService authTicketService) {
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.nodeConfigurationSource = (NodeConfigurationSource)Preconditions.checkNotNull((Object)nodeConfigurationSource);
        this.hazelcastExecutor = (HazelcastExecutor)((Object)Preconditions.checkNotNull((Object)((Object)hazelcastExecutor)));
        this.downloadService = (DownloadService)Preconditions.checkNotNull((Object)downloadService);
        this.authTicketService = (AuthTicketService)Preconditions.checkNotNull((Object)authTicketService);
    }

    @Override
    @GET
    @Timed
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:nodes:read"})
    public List<NodeXO> get() {
        if (this.nodeAccess.isClustered()) {
            return ((HazelcastInstance)this.hazelcastProvider.get()).getCluster().getMembers().stream().map(this::memberToNode).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    @PUT
    @Timed
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:nodes:update"})
    public NodeXO update(@NotNull @Valid NodeXO nodeXO) {
        if (this.nodeAccess.isClustered()) {
            if (!this.memberExists(nodeXO.getNodeIdentity())) {
                throw new WebApplicationException(String.format("no node found with identity '%s'", nodeXO.getNodeIdentity()), Response.Status.NOT_FOUND);
            }
            this.log.debug("updating node {} to have friendly name: {}", (Object)nodeXO.getNodeIdentity(), (Object)nodeXO.getFriendlyName());
            if (nodeXO.getFriendlyName() != null) {
                this.nodeConfigurationSource.setFriendlyName(nodeXO.getNodeIdentity(), nodeXO.getFriendlyName());
            } else {
                this.nodeConfigurationSource.delete(nodeXO.getNodeIdentity());
            }
            return this.memberToNode(((HazelcastInstance)this.hazelcastProvider.get()).getCluster().getMembers().stream().filter(m -> nodeXO.getNodeIdentity().equals(HazelcastNodeAccess.getNodeId(m))).findAny().orElse(null));
        }
        throw new WebApplicationException("HA-C is not enabled", Response.Status.BAD_REQUEST);
    }

    @Override
    @POST
    @Path(value="/supportzips")
    @Timed
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:atlas:create"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<NodeSupportZipXO> createSupportZips(SupportZipGenerator.Request request) {
        if (!this.nodeAccess.isClustered()) {
            return Collections.emptyList();
        }
        String baseDownloadUrl = String.valueOf(BaseUrlHolder.get()) + "/service/rest" + RESOURCE_URI + SUPPORT_ZIP_DOWNLOAD_PATH;
        return this.hazelcastExecutor.executeOnAllNodes(new SupportZipHazelcastJob(request)).stream().map(r -> this.fromResult((HazelcastJobResult<SupportZipGenerator.Result>)r, baseDownloadUrl)).collect(Collectors.toList());
    }

    @Override
    @GET
    @Path(value="/supportzipdownload")
    @Timed
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:atlas:read"})
    @Produces(value={"application/octet-stream"})
    @NotCacheable
    public Response downloadSupportZip(@QueryParam(value="id") String id) {
        try {
            String ticket = this.authTicketService.createTicket();
            String zipName = Strings2.decodeBase64((String)id);
            DownloadService.Download download = this.downloadService.get(zipName, ticket);
            if (download == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)download.getBytes()).header("Content-Disposition", (Object)("attachment; filename=\"" + zipName + "\"")).header("Content-Length", (Object)download.getLength()).build();
        }
        catch (Exception e) {
            this.log.error("Error retrieving HA-C support zip: " + e.getMessage(), (Throwable)e);
            throw new WebApplicationException("Unable to retrieve support zip with id: " + id, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Nullable
    protected NodeXO memberToNode(@Nullable Member member) {
        if (member == null) {
            return null;
        }
        String nodeId = HazelcastNodeAccess.getNodeId(member);
        NodeXO node = new NodeXO();
        node.setNodeIdentity(nodeId);
        node.setSocketAddress(member.getSocketAddress().toString());
        this.nodeConfigurationSource.getById(nodeId).ifPresent(config -> node.setFriendlyName(config.getFriendlyNodeName()));
        return node;
    }

    private boolean memberExists(@Nullable String nodeIdentity) {
        if (nodeIdentity == null) {
            return false;
        }
        return ((HazelcastInstance)this.hazelcastProvider.get()).getCluster().getMembers().stream().anyMatch(m -> nodeIdentity.equals(HazelcastNodeAccess.getNodeId(m)));
    }

    private NodeSupportZipXO fromResult(HazelcastJobResult<SupportZipGenerator.Result> jobResult, String baseDownloadUrl) {
        NodeSupportZipXO zipXO = new NodeSupportZipXO();
        zipXO.setNodeId(jobResult.getNodeId());
        zipXO.setNodeAlias((String)this.nodeAccess.getMemberAliases().get(jobResult.getNodeId()));
        SupportZipGenerator.Result supportZipResult = jobResult.getResult();
        if (supportZipResult != null) {
            String zipId = supportZipResult.getFilename();
            zipXO.setUrl(String.valueOf(baseDownloadUrl) + "?id=" + Strings2.encodeBase64((String)zipId));
            zipXO.setDetail("Support zip created: " + zipId);
            zipXO.setFile(supportZipResult.getLocalPath());
            zipXO.setName(zipId);
            zipXO.setSize(Long.toString(supportZipResult.getSize()));
            zipXO.setTruncated(supportZipResult.isTruncated());
        } else {
            zipXO.setDetail("Support zip creation failed" + (jobResult.getError() != null ? " with message: " + jobResult.getError().getMessage() : ""));
        }
        return zipXO;
    }
}

