/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.raw;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadRegexMap;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;

public abstract class RawUploadHandlerSupport
extends UploadHandlerSupport {
    protected static final String FILENAME = "filename";
    protected static final String DIRECTORY = "directory";
    protected static final String DIRECTORY_HELP_TEXT = "Destination for uploaded files (e.g. /path/to/files/)";
    protected static final String FIELD_GROUP_NAME = "Component attributes";
    protected final ContentPermissionChecker contentPermissionChecker;
    protected final VariableResolverAdapter variableResolverAdapter;
    protected UploadDefinition definition;

    public RawUploadHandlerSupport(ContentPermissionChecker contentPermissionChecker, VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = variableResolverAdapter;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        String basePath = ((String)upload.getFields().get(DIRECTORY)).trim();
        LinkedHashMap<String, PartPayload> pathToPayload = new LinkedHashMap<String, PartPayload>();
        for (AssetUpload asset : upload.getAssetUploads()) {
            String path = this.normalizePath(String.valueOf(basePath) + '/' + ((String)asset.getFields().get(FILENAME)).trim());
            this.ensurePermitted(repository.getName(), "raw", path, Collections.emptyMap());
            pathToPayload.put(path, asset.getPayload());
        }
        List<Content> responseContents = this.getResponseContents(repository, pathToPayload);
        return new UploadResponse(responseContents, new ArrayList(pathToPayload.keySet()));
    }

    protected abstract List<Content> getResponseContents(Repository var1, Map<String, PartPayload> var2) throws IOException;

    public Content handle(Repository repository, File content, String path) throws IOException {
        return this.handle(new ImportFileConfiguration(repository, content, path));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        this.ensurePermitted(configuration.getRepository().getName(), "raw", configuration.getAssetName(), Collections.emptyMap());
        return this.doPut(configuration);
    }

    protected abstract Content doPut(ImportFileConfiguration var1) throws IOException;

    protected String normalizePath(String path) {
        String result = path.replaceAll("/+", "/");
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("raw", true, Collections.singletonList(new UploadFieldDefinition(DIRECTORY, DIRECTORY_HELP_TEXT, false, UploadFieldDefinition.Type.STRING, FIELD_GROUP_NAME)), Collections.singletonList(new UploadFieldDefinition(FILENAME, false, UploadFieldDefinition.Type.STRING)), new UploadRegexMap("(.*)", new String[]{FILENAME}));
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public boolean supportsExportImport() {
        return true;
    }
}

