/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.raw.internal;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.raw.RawContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class RawContentHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String name = this.contentName(context);
        String method = context.getRequest().getAction();
        Repository repository = context.getRepository();
        this.log.debug("{} repository '{}' content-name: {}", new Object[]{method, repository.getName(), name});
        RawContentFacet storage = (RawContentFacet)repository.facet(RawContentFacet.class);
        switch (method) {
            case "GET": 
            case "HEAD": {
                Content content = storage.get(name);
                if (content == null) {
                    return HttpResponses.notFound((String)name);
                }
                return HttpResponses.ok((Payload)content);
            }
            case "PUT": {
                Payload content = context.getRequest().getPayload();
                storage.put(name, content);
                return HttpResponses.created();
            }
            case "DELETE": {
                boolean deleted = storage.delete(name);
                if (!deleted) {
                    return HttpResponses.notFound((String)name);
                }
                return HttpResponses.noContent();
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD", "PUT", "DELETE"});
    }

    @Nonnull
    private String contentName(Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String name = (String)state.getTokens().get("name");
        Preconditions.checkState((name != null ? 1 : 0) != 0, (Object)"Missing token: name");
        return name;
    }
}

