/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.raw.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.orient.raw.RawContentFacet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.raw.RawCoordinatesHelper;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class RawContentFacetImpl
extends FacetSupport
implements RawContentFacet {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.MD5, (Object)HashAlgorithm.SHA1);
    private final AssetEntityAdapter assetEntityAdapter;

    @Inject
    public RawContentFacetImpl(AssetEntityAdapter assetEntityAdapter) {
        this.assetEntityAdapter = (AssetEntityAdapter)Preconditions.checkNotNull((Object)assetEntityAdapter);
    }

    protected void doValidate(Configuration configuration) throws Exception {
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content get(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.findAsset(tx, path);
        if (asset == null) {
            return null;
        }
        Blob blob = tx.requireBlob(asset.requireBlobRef());
        return this.toContent(asset, blob);
    }

    @Override
    public Content put(String path, Payload content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, HASH_ALGORITHMS);){
            return this.doPutContent(path, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @TransactionalStoreBlob
    public Asset put(String path, AssetBlob assetBlob, @Nullable AttributesMap contentAttributes) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.getOrCreateAsset(this.getRepository(), path, RawCoordinatesHelper.getGroup(path), path);
        tx.attachBlob(asset, assetBlob);
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        tx.saveAsset(asset);
        return asset;
    }

    @TransactionalStoreBlob
    protected Content doPutContent(String path, TempBlob tempBlob, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.getOrCreateAsset(this.getRepository(), path, RawCoordinatesHelper.getGroup(path), path);
        AttributesMap contentAttributes = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
        }
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, path, tempBlob, null, payload.getContentType(), false);
        tx.saveAsset(asset);
        return this.toContent(asset, assetBlob.getBlob());
    }

    @Override
    @TransactionalStoreMetadata
    public Asset getOrCreateAsset(Repository repository, String componentName, String componentGroup, String assetName) {
        Asset asset;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentWithProperty("name", (Object)componentName, bucket = tx.findBucket(this.getRepository()));
        if (component == null) {
            component = (Component)tx.createComponent(bucket, this.getRepository().getFormat()).group(componentGroup).name(componentName);
            tx.saveComponent(component);
            asset = tx.createAsset(bucket, component);
            asset.name(assetName);
        } else {
            asset = tx.firstAsset(component);
            asset = asset != null ? asset : (Asset)tx.createAsset(bucket, component).name(assetName);
        }
        return asset;
    }

    @Override
    @TransactionalDeleteBlob
    public boolean delete(String path) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = this.findComponent(tx, tx.findBucket(this.getRepository()), path);
        if (component == null) {
            return false;
        }
        tx.deleteComponent(component);
        return true;
    }

    @Override
    @TransactionalTouchMetadata
    public void setCacheInfo(String path, Content content, CacheInfo cacheInfo) throws IOException {
        Component component;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)(bucket = tx.findBucket(this.getRepository())), (Content)content);
        if (asset == null && (component = tx.findComponentWithProperty("name", (Object)path, bucket)) != null) {
            asset = tx.firstAsset(component);
        }
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent raw component {}", (Object)path);
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)path, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    @Override
    @Transactional
    public boolean assetExists(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return this.assetEntityAdapter.exists(tx.getDb(), name, tx.findBucket(this.getRepository()));
    }

    private Component findComponent(StorageTx tx, Bucket bucket, String path) {
        return tx.findComponentWithProperty("name", (Object)path, bucket);
    }

    private Asset findAsset(StorageTx tx, String path) {
        return tx.findAssetWithProperty("name", (Object)path, tx.findBucket(this.getRepository()));
    }

    private Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }
}

