/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.raw.internal;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.orient.raw.RawContentFacet;
import org.sonatype.nexus.repository.raw.RawCoordinatesHelper;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.OrientReplicationFacetSupport;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientRawReplicationFacet
extends OrientReplicationFacetSupport {
    public void doReplicate(String path, AssetBlob assetBlob, NestedAttributesMap assetAttributes, NestedAttributesMap componentAttributes) {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        UnitOfWork.begin((Supplier)storageFacet.txSupplier());
        try {
            this.putPreservingAllAttributes(path, assetBlob, (AttributesMap)assetAttributes);
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalStoreBlob
    protected void putPreservingAllAttributes(String path, AssetBlob assetBlob, @Nullable AttributesMap contentAttributes) {
        RawContentFacet rawContentFacet = (RawContentFacet)this.facet(RawContentFacet.class);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = rawContentFacet.getOrCreateAsset(this.getRepository(), path, RawCoordinatesHelper.getGroup(path), path);
        tx.attachBlob(asset, assetBlob);
        asset.attributes((NestedAttributesMap)contentAttributes);
        tx.saveAsset(asset);
    }

    public boolean doReplicateDelete(String path) {
        Asset asset;
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        UnitOfWork.begin((Supplier)storageFacet.txSupplier());
        try {
            asset = this.findAssetTransactional(path);
            if (asset == null) {
                this.log.debug("Skipping replication delete with asset {} as it doesn't exist.", (Object)path);
                return false;
            }
        }
        finally {
            UnitOfWork.end();
        }
        this.log.debug("Replicating delete to asset {}", (Object)path);
        return !((ComponentMaintenance)this.getRepository().facet(ComponentMaintenance.class)).deleteAsset(asset.getEntityMetadata().getId()).isEmpty();
    }

    @Transactional
    protected Asset findAssetTransactional(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.findAssetWithProperty("name", (Object)path, tx.findBucket(this.getRepository()));
    }
}

