/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.raw;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.orient.raw.RawContentFacet;
import org.sonatype.nexus.orient.raw.internal.RawContentFacetImpl;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.raw.RawUploadHandlerSupport;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="raw")
@Singleton
public class RawUploadHandler
extends RawUploadHandlerSupport {
    private final MimeSupport mimeSupport;

    @Inject
    public RawUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions, MimeSupport mimeSupport) {
        super(contentPermissionChecker, variableResolverAdapter, uploadDefinitionExtensions);
        this.mimeSupport = mimeSupport;
    }

    @Override
    protected List<Content> getResponseContents(Repository repository, Map<String, PartPayload> pathToPayload) throws IOException {
        RawContentFacet facet = (RawContentFacet)repository.facet(RawContentFacet.class);
        ArrayList responseContents = Lists.newArrayList();
        UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
        try {
            for (Map.Entry<String, PartPayload> entry : pathToPayload.entrySet()) {
                String path = entry.getKey();
                Content content = facet.put(path, (Payload)entry.getValue());
                responseContents.add(content);
            }
        }
        finally {
            UnitOfWork.end();
        }
        return responseContents;
    }

    /*
     * Loose catch block
     */
    @Override
    protected Content doPut(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        String path = configuration.getAssetName();
        Path contentPath = configuration.getFile().toPath();
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Content content;
            BufferedInputStream in;
            TempBlob tempBlob;
            block16: {
                block15: {
                    tempBlob = ((StorageFacet)repository.facet(StorageFacet.class)).createTempBlob(contentPath, RawContentFacetImpl.HASH_ALGORITHMS, configuration.isHardLinkingEnabled());
                    in = new BufferedInputStream(Files.newInputStream(contentPath, StandardOpenOption.READ));
                    RawContentFacet facet = (RawContentFacet)repository.facet(RawContentFacet.class);
                    facet.put(path, (Payload)new TempBlobPayload(tempBlob, this.mimeSupport.detectMimeType((InputStream)in, contentPath.getFileName().toString())));
                    content = facet.get(path);
                    if (in == null) break block15;
                    ((InputStream)in).close();
                }
                if (tempBlob == null) break block16;
                tempBlob.close();
            }
            return content;
            {
                catch (Throwable throwable2) {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (tempBlob != null) {
                            tempBlob.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

