/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.raw.internal.recipe;

import java.util.Map;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.content.AttributeChangeSet;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.replication.ReplicationFacetSupport;
import org.sonatype.nexus.repository.raw.RawCoordinatesHelper;
import org.sonatype.nexus.repository.replication.ReplicationUtils;

@Named(value="raw")
public class RawReplicationFacet
extends ReplicationFacetSupport {
    public void doReplicate(String path, Blob blob, Map<String, Object> assetAttributes, Map<String, Object> componentAttributes) {
        ContentFacet contentFacet = (ContentFacet)this.facet(ContentFacet.class);
        FluentAssets fluentAssets = contentFacet.assets();
        FluentComponents fluentComponents = contentFacet.components();
        FluentAsset fluentAsset = fluentAssets.path(path).component((Component)fluentComponents.name(path).namespace(RawCoordinatesHelper.getGroup(path)).getOrCreate()).blob(blob, ReplicationUtils.getChecksumsFromProperties(assetAttributes)).save();
        AttributeChangeSet changeSet = new AttributeChangeSet();
        for (Map.Entry<String, Object> entry : assetAttributes.entrySet()) {
            changeSet.attributes(AttributeOperation.SET, entry.getKey(), entry.getValue());
        }
        fluentAsset.attributes(changeSet);
    }
}

