/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.raw.internal.recipe;

import java.io.IOException;
import javax.inject.Named;
import org.sonatype.nexus.common.template.EscapeHelper;
import org.sonatype.nexus.content.raw.RawContentFacet;
import org.sonatype.nexus.content.raw.internal.recipe.RawProxyRecipe;
import org.sonatype.nexus.repository.content.facet.ContentProxyFacetSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
public class RawProxyFacet
extends ContentProxyFacetSupport {
    protected Content getCachedContent(Context context) throws IOException {
        return this.content().get(this.assetPath(context)).orElse(null);
    }

    protected Content store(Context context, Content payload) throws IOException {
        return this.content().put(this.assetPath(context), (Payload)payload);
    }

    protected String getUrl(Context context) {
        return new EscapeHelper().uriSegments(this.removeSlashPrefix(this.assetPath(context)));
    }

    private RawContentFacet content() {
        return (RawContentFacet)this.getRepository().facet(RawContentFacet.class);
    }

    private String assetPath(Context context) {
        TokenMatcher.State tokenMatcherState = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        return (String)tokenMatcherState.getTokens().get(RawProxyRecipe.PATH_NAME);
    }

    private String removeSlashPrefix(String url) {
        return url != null && url.startsWith("/") ? url.substring(1) : url;
    }
}

