/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.raw.internal.recipe;

import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.content.raw.RawContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.raw.RawCoordinatesHelper;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="raw")
public class RawContentFacetImpl
extends ContentFacetSupport
implements RawContentFacet {
    @Inject
    public RawContentFacetImpl(@Named(value="raw") FormatStoreManager formatStoreManager) {
        super(formatStoreManager);
    }

    @Override
    public Optional<Content> get(String path) throws IOException {
        return this.assets().path(path).find().map(FluentAsset::download);
    }

    @Override
    public FluentAsset getOrCreateAsset(Repository repository, String componentName, String componentGroup, String assetName) {
        return this.assets().path(componentName).component((Component)this.components().name(componentName).namespace(RawCoordinatesHelper.getGroup(componentName)).getOrCreate()).save();
    }

    @Override
    public Content put(String path, Payload content) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.blobs().ingest(content, HASHING);){
            return this.assets().path(path).component((Component)this.components().name(path).namespace(RawCoordinatesHelper.getGroup(path)).getOrCreate()).blob(blob).save().markAsCached(content).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean delete(String path) throws IOException {
        return this.assets().path(path).find().map(asset -> ((ContentMaintenanceFacet)this.repository().facet(ContentMaintenanceFacet.class)).deleteAsset((Asset)asset).contains(path)).orElse(false);
    }
}

