/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.content.raw;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.content.raw.RawContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.raw.RawUploadHandlerSupport;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPayload;

@Named(value="raw")
@Singleton
public class RawUploadHandler
extends RawUploadHandlerSupport {
    @Inject
    public RawUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(contentPermissionChecker, variableResolverAdapter, uploadDefinitionExtensions);
    }

    @Override
    protected List<Content> getResponseContents(Repository repository, Map<String, PartPayload> pathToPayload) throws IOException {
        RawContentFacet facet = (RawContentFacet)repository.facet(RawContentFacet.class);
        ArrayList responseContents = Lists.newArrayList();
        for (Map.Entry<String, PartPayload> entry : pathToPayload.entrySet()) {
            String path = entry.getKey();
            Content content = facet.put(path, (Payload)entry.getValue());
            responseContents.add(content);
        }
        return responseContents;
    }

    @Override
    protected Content doPut(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        String path = configuration.getAssetName();
        Path contentPath = configuration.getFile().toPath();
        RawContentFacet contentFacet = (RawContentFacet)repository.facet(RawContentFacet.class);
        String contentType = Files.probeContentType(contentPath);
        Throwable throwable = null;
        Object var8_9 = null;
        try (TempBlob blob = contentFacet.blobs().ingest(contentPath, contentType, RawContentFacet.HASHING, configuration.isHardLinkingEnabled());){
            return contentFacet.put(path, (Payload)new TempBlobPayload(blob, contentType));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected String normalizePath(String path) {
        return "/" + super.normalizePath(path);
    }
}

