/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.httpclient;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.sonatype.goodies.common.ComponentSupport;

public class HttpClientPlan
extends ComponentSupport {
    private final HttpClientBuilder client = HttpClientBuilder.create();
    private final ConnectionConfig.Builder connection = ConnectionConfig.copy((ConnectionConfig)ConnectionConfig.DEFAULT);
    private final SocketConfig.Builder socket = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT);
    private final RequestConfig.Builder request = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    @Nullable
    private CredentialsProvider credentials;
    @Nullable
    private String userAgentBase;
    @Nullable
    private String userAgentSuffix;

    public HttpClientBuilder getClient() {
        return this.client;
    }

    public ConnectionConfig.Builder getConnection() {
        return this.connection;
    }

    public SocketConfig.Builder getSocket() {
        return this.socket;
    }

    public RequestConfig.Builder getRequest() {
        return this.request;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void addCredentials(AuthScope authScope, Credentials credentials) {
        if (this.credentials == null) {
            this.credentials = new BasicCredentialsProvider();
        }
        this.credentials.setCredentials(authScope, credentials);
    }

    @Nullable
    public CredentialsProvider getCredentials() {
        return this.credentials;
    }

    @Nullable
    public String getUserAgentBase() {
        return this.userAgentBase;
    }

    public void setUserAgentBase(@Nullable String userAgentBase) {
        this.userAgentBase = userAgentBase;
    }

    @Nullable
    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public void setUserAgentSuffix(@Nullable String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
    }

    @Nullable
    public String getUserAgent() {
        if (this.userAgentBase != null && this.userAgentSuffix != null) {
            return String.valueOf(this.userAgentBase) + " " + this.userAgentSuffix;
        }
        return this.userAgentBase;
    }

    public static interface Customizer {
        public void customize(HttpClientPlan var1);
    }
}

