/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.cyclonedx.model.ExtensibleType;
import org.cyclonedx.model.Extension;
import org.cyclonedx.model.Source;
import org.cyclonedx.model.vulnerability.Rating;
import org.cyclonedx.model.vulnerability.Vulnerability10;

public class ExtensionDeserializer
extends StdDeserializer<Extension> {
    public ExtensionDeserializer() {
        this(Extension.class);
    }

    public ExtensionDeserializer(Class vc) {
        super(vc);
    }

    public Extension deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.currentName().equals("vulnerabilities") && p instanceof FromXmlParser) {
            return this.processVulnerabilities(p);
        }
        return null;
    }

    private Extension processVulnerabilities(JsonParser parser) throws IOException {
        TreeNode treeNode = parser.readValueAsTree();
        JsonNode vulnerabilityNode = (JsonNode)treeNode.get("vulnerability");
        ArrayList<ExtensibleType> extensibleTypes = new ArrayList<ExtensibleType>();
        if (vulnerabilityNode != null) {
            if (vulnerabilityNode.isArray() && !vulnerabilityNode.isEmpty()) {
                for (JsonNode jn : vulnerabilityNode) {
                    Vulnerability10 vulnerability = this.processVulnerability(jn);
                    extensibleTypes.add(vulnerability);
                }
            } else {
                Vulnerability10 vuln = this.processVulnerability(vulnerabilityNode);
                extensibleTypes.add(vuln);
            }
        }
        if (!extensibleTypes.isEmpty()) {
            return this.createAndReturnExtension(Extension.ExtensionType.VULNERABILITIES, extensibleTypes);
        }
        return null;
    }

    private Vulnerability10 processVulnerability(JsonNode vulnJson) {
        Vulnerability10 vuln = new Vulnerability10();
        Iterator it = vulnJson.fieldNames();
        while (it.hasNext()) {
            String field;
            switch (field = (String)it.next()) {
                case "ref": {
                    vuln.setRef(vulnJson.get(field).textValue());
                    break;
                }
                case "id": {
                    vuln.setId(vulnJson.get(field).textValue());
                    break;
                }
                case "source": {
                    vuln.setSource(this.processSource(vulnJson.get(field)));
                    break;
                }
                case "ratings": {
                    vuln.setRatings(this.processRatings(vulnJson.get(field)));
                    break;
                }
                case "cwes": {
                    vuln.setCwes(this.processCwes(vulnJson.get(field)));
                    break;
                }
                case "description": {
                    vuln.setDescription(vulnJson.get(field).textValue());
                    break;
                }
                case "recommendations": {
                    vuln.setRecommendations(this.processRecommendations(vulnJson.get(field)));
                    break;
                }
                case "advisories": {
                    vuln.setAdvisories(this.processAdvisories(vulnJson.get(field)));
                    break;
                }
            }
        }
        return vuln;
    }

    private List<Vulnerability10.Advisory> processAdvisories(JsonNode advisories) {
        ArrayList<Vulnerability10.Advisory> advisoryList = new ArrayList<Vulnerability10.Advisory>();
        JsonNode adv = advisories.get("advisory");
        if (adv != null) {
            if (adv.isArray() && !adv.isEmpty()) {
                for (JsonNode a : adv) {
                    advisoryList.add(this.processAdvisory(a));
                }
            } else {
                advisoryList.add(this.processAdvisory(adv));
            }
        }
        return advisoryList.isEmpty() ? null : advisoryList;
    }

    private Vulnerability10.Advisory processAdvisory(JsonNode advisory) {
        Vulnerability10.Advisory adv = new Vulnerability10.Advisory();
        adv.setText(advisory.textValue());
        return adv;
    }

    private List<Vulnerability10.Recommendation> processRecommendations(JsonNode recommendations) {
        ArrayList<Vulnerability10.Recommendation> recommendationsList = new ArrayList<Vulnerability10.Recommendation>();
        JsonNode rec = recommendations.get("recommendation");
        if (rec != null) {
            if (rec.isArray() && !rec.isEmpty()) {
                for (JsonNode r : rec) {
                    recommendationsList.add(this.processRecommendation(r));
                }
            } else {
                recommendationsList.add(this.processRecommendation(rec));
            }
        }
        return recommendationsList.isEmpty() ? null : recommendationsList;
    }

    private Vulnerability10.Recommendation processRecommendation(JsonNode recommendation) {
        Vulnerability10.Recommendation rec = new Vulnerability10.Recommendation();
        rec.setText(recommendation.textValue());
        return rec;
    }

    private List<Vulnerability10.Cwe> processCwes(JsonNode cwes) {
        ArrayList<Vulnerability10.Cwe> cweList = new ArrayList<Vulnerability10.Cwe>();
        JsonNode cwe = cwes.get("cwe");
        if (cwe != null) {
            if (cwe.isArray() && !cwe.isEmpty()) {
                for (JsonNode c : cwe) {
                    cweList.add(this.processCwe(c));
                }
            } else {
                cweList.add(this.processCwe(cwe));
            }
        }
        return cweList.isEmpty() ? null : cweList;
    }

    private Vulnerability10.Cwe processCwe(JsonNode cwe) {
        Vulnerability10.Cwe c = new Vulnerability10.Cwe();
        if (NumberUtils.isParsable((String)cwe.textValue())) {
            c.setText(Integer.valueOf(cwe.textValue()));
        }
        return c;
    }

    private Source processSource(JsonNode sourceNode) {
        Source source = new Source();
        source.setName(this.getAsString("name", sourceNode));
        if (sourceNode.get("url") != null) {
            try {
                source.setUrl(new URL(sourceNode.get("url").textValue()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return source;
    }

    private List<Rating> processRatings(JsonNode ratings) {
        ArrayList<Rating> ratingsList = new ArrayList<Rating>();
        if (ratings != null) {
            if (ratings.isArray() && !ratings.isEmpty()) {
                for (JsonNode rating : ratings) {
                    ratingsList.add(this.processRating(rating));
                }
            } else {
                ratingsList.add(this.processRating(ratings));
            }
        }
        return ratingsList.isEmpty() ? null : ratingsList;
    }

    private Rating processRating(JsonNode ratingNode) {
        Rating rating = new Rating();
        JsonNode r = ratingNode.get("rating");
        if (r != null) {
            if (r.get("score") != null) {
                Vulnerability10.Score score = new Vulnerability10.Score();
                JsonNode s = r.get("score");
                score.setBase(this.getAsDouble("base", s));
                score.setImpact(this.getAsDouble("impact", s));
                score.setExploitability(this.getAsDouble("exploitability", s));
                rating.setScore(score);
            }
            rating.setSeverity(Vulnerability10.Severity.fromString(this.getAsString("severity", r)));
            rating.setMethod(Vulnerability10.ScoreSource.fromString(this.getAsString("method", r)));
            rating.setVector(this.getAsString("vector", r));
        }
        return rating;
    }

    private Extension createAndReturnExtension(Extension.ExtensionType extType, List<ExtensibleType> list) {
        if (extType == Extension.ExtensionType.VULNERABILITIES) {
            Extension ext = new Extension(extType, list);
            ext.setNamespaceURI("http://cyclonedx.org/schema/ext/vulnerability/1.0");
            ext.setPrefix("v");
            return ext;
        }
        return null;
    }

    private Double getAsDouble(String fieldName, JsonNode node) {
        if (node.get(fieldName) != null) {
            return node.get(fieldName).asDouble();
        }
        return null;
    }

    private String getAsString(String fieldName, JsonNode node) {
        if (node.get(fieldName) != null) {
            return node.get(fieldName).textValue();
        }
        return null;
    }
}

