/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.cyclonedx.model.Dependency;

public class DependencySerializer
extends StdSerializer<List<Dependency>> {
    private final String NAMESPACE_PREFIX = "dg";
    private final String DEPENDENCY = "dependency";
    private final String DEPENDENCIES = "dependencies";
    private final String REF = "ref";
    private final String NAMESPACE_URI = "http://cyclonedx.org/schema/ext/dependency-graph/1.0";
    private boolean useNamespace = false;

    public DependencySerializer(boolean useNamespace) {
        this(null);
        this.useNamespace = useNamespace;
    }

    public DependencySerializer(Class t) {
        super(t);
    }

    public void serialize(List<Dependency> dependencies, JsonGenerator generator, SerializerProvider provider) throws IOException {
        try {
            if (generator instanceof ToXmlGenerator) {
                this.writeXMLDependenciesWithGenerator((ToXmlGenerator)generator, dependencies);
            } else {
                this.writeJSONDependenciesWithGenerator(generator, dependencies);
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    private void writeJSONDependenciesWithGenerator(JsonGenerator generator, List<Dependency> dependencies) throws IOException {
        if (dependencies != null && !dependencies.isEmpty()) {
            generator.writeStartArray();
            for (Dependency dependency : dependencies) {
                generator.writeStartObject();
                generator.writeStringField("ref", dependency.getRef());
                generator.writeArrayFieldStart("dependsOn");
                if (dependency.getDependencies() != null && !dependency.getDependencies().isEmpty()) {
                    for (Dependency subDependency : dependency.getDependencies()) {
                        generator.writeString(subDependency.getRef());
                    }
                }
                generator.writeEndArray();
                generator.writeEndObject();
            }
            generator.writeEndArray();
        }
    }

    private void writeXMLDependenciesWithGenerator(ToXmlGenerator toXmlGenerator, List<Dependency> dependencies) throws IOException, XMLStreamException {
        if (dependencies != null && !dependencies.isEmpty()) {
            QName qName;
            if (this.useNamespace) {
                qName = new QName("http://cyclonedx.org/schema/ext/dependency-graph/1.0", "dependencies", "dg");
                toXmlGenerator.getStaxWriter().setPrefix(qName.getPrefix(), qName.getNamespaceURI());
            } else {
                qName = new QName("dependencies");
            }
            toXmlGenerator.setNextName(qName);
            toXmlGenerator.writeStartObject();
            toXmlGenerator.writeFieldName(qName.getLocalPart());
            toXmlGenerator.writeStartArray();
            for (Dependency dependency : dependencies) {
                this.writeXMLDependency(dependency, toXmlGenerator);
            }
            toXmlGenerator.writeEndArray();
            toXmlGenerator.writeEndObject();
        }
    }

    private void writeXMLDependency(Dependency dependency, ToXmlGenerator generator) throws IOException, XMLStreamException {
        QName qName;
        if (this.useNamespace) {
            qName = new QName("http://cyclonedx.org/schema/ext/dependency-graph/1.0", "dependency", "dg");
            generator.getStaxWriter().setPrefix(qName.getPrefix(), qName.getNamespaceURI());
        } else {
            qName = new QName("dependency");
        }
        generator.setNextName(qName);
        generator.writeStartObject();
        generator.writeFieldName(qName.getLocalPart());
        if (dependency.getDependencies() != null && !dependency.getDependencies().isEmpty()) {
            generator.writeStartArray();
        }
        generator.setNextIsAttribute(true);
        generator.setNextName(new QName("ref"));
        generator.writeString(dependency.getRef());
        generator.setNextIsAttribute(false);
        if (dependency.getDependencies() != null && !dependency.getDependencies().isEmpty()) {
            for (Dependency subDependency : dependency.getDependencies()) {
                this.writeXMLDependency(subDependency, generator);
            }
        }
        if (dependency.getDependencies() != null && !dependency.getDependencies().isEmpty()) {
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }
}

