/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Composition;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.JsonOnly;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.Service;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.model.XmlOnly;
import org.cyclonedx.util.DependencyDeserializer;

@JacksonXmlRootElement(localName="bom")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"bomFormat", "specVersion", "serialNumber", "version", "metadata", "components", "services", "externalReferences", "dependencies", "compositions", "properties"})
public class Bom
extends ExtensibleElement {
    @XmlOnly
    @JacksonXmlProperty(isAttribute=true)
    private String xmlns;
    @VersionFilter(versions={"1.2", "1.3"})
    private Metadata metadata;
    @VersionFilter(versions={"1.0", "1.1", "1.2", "1.3"})
    private List<Component> components;
    @VersionFilter(versions={"1.2", "1.3"})
    private List<Service> services;
    @VersionFilter(versions={"1.1", "1.2", "1.3"})
    private List<Dependency> dependencies;
    @VersionFilter(versions={"1.1", "1.2", "1.3"})
    private List<ExternalReference> externalReferences;
    @VersionFilter(versions={"1.3"})
    private List<Composition> compositions;
    @VersionFilter(versions={"1.3"})
    private List<Property> properties;
    @JacksonXmlProperty(isAttribute=true)
    private int version = 1;
    @JacksonXmlProperty(isAttribute=true)
    private String serialNumber;
    @JsonOnly
    private String specVersion;
    @JsonOnly
    private String bomFormat;

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @JacksonXmlElementWrapper(localName="components")
    @JacksonXmlProperty(localName="component")
    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void addComponent(Component component) {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        this.components.add(component);
    }

    @JacksonXmlElementWrapper(localName="services")
    @JacksonXmlProperty(localName="service")
    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public void addService(Service service) {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.add(service);
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JsonDeserialize(using=DependencyDeserializer.class)
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(Dependency dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        this.dependencies.add(dependency);
    }

    public List<ExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public void addExternalReference(ExternalReference externalReference) {
        if (this.externalReferences == null) {
            this.externalReferences = new ArrayList<ExternalReference>();
        }
        this.externalReferences.add(externalReference);
    }

    public void setExternalReferences(List<ExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    @JacksonXmlElementWrapper(localName="compositions")
    @JacksonXmlProperty(localName="composition")
    public List<Composition> getCompositions() {
        return this.compositions;
    }

    public void setCompositions(List<Composition> compositions) {
        this.compositions = compositions;
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public void setXmlns(String xmlns) {
        this.xmlns = xmlns;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getBomFormat() {
        return this.bomFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bom bom = (Bom)o;
        return this.version == bom.version && Objects.equals(this.metadata, bom.metadata) && Objects.equals(this.components, bom.components) && Objects.equals(this.dependencies, bom.dependencies) && Objects.equals(this.externalReferences, bom.externalReferences) && Objects.equals(this.compositions, bom.compositions) && Objects.equals(this.properties, bom.properties) && Objects.equals(this.serialNumber, bom.serialNumber) && Objects.equals(this.specVersion, bom.specVersion);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.components, this.dependencies, this.externalReferences, this.compositions, this.properties, this.version, this.serialNumber, this.specVersion);
    }
}

