/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.orient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;

public class OrientDelegate
extends StdJDBCDelegate {
    public JobDetail selectJobForTrigger(Connection conn, ClassLoadHelper loadHelper, TriggerKey triggerKey, boolean loadJobClass) throws ClassNotFoundException, SQLException {
        String jobGroup;
        String jobName;
        ResultSet rs;
        PreparedStatement ps;
        block8: {
            block9: {
                ps = null;
                rs = null;
                try {
                    ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                    ps.setString(1, triggerKey.getName());
                    ps.setString(2, triggerKey.getGroup());
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        jobName = rs.getString("JOB_NAME");
                        jobGroup = rs.getString("JOB_GROUP");
                        break block8;
                    }
                    if (!this.logger.isDebugEnabled()) break block9;
                    this.logger.debug("No job for trigger '{}'.", (Object)triggerKey);
                }
                catch (Throwable throwable) {
                    OrientDelegate.closeResultSet(rs);
                    OrientDelegate.closeStatement((Statement)ps);
                    throw throwable;
                }
            }
            OrientDelegate.closeResultSet((ResultSet)rs);
            OrientDelegate.closeStatement((Statement)ps);
            return null;
        }
        OrientDelegate.closeResultSet((ResultSet)rs);
        OrientDelegate.closeStatement((Statement)ps);
        try {
            ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}JOB_DETAILS WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, jobGroup);
            rs = ps.executeQuery();
            if (rs.next()) {
                JobDetailImpl job = new JobDetailImpl();
                job.setName(jobName);
                job.setGroup(jobGroup);
                job.setDurability(this.getBoolean(rs, "IS_DURABLE"));
                if (loadJobClass) {
                    job.setJobClass(loadHelper.loadClass(rs.getString("JOB_CLASS_NAME"), Job.class));
                }
                job.setRequestsRecovery(this.getBoolean(rs, "REQUESTS_RECOVERY"));
                JobDetailImpl jobDetailImpl = job;
                return jobDetailImpl;
            }
            return null;
        }
        finally {
            OrientDelegate.closeResultSet((ResultSet)rs);
            OrientDelegate.closeStatement((Statement)ps);
        }
    }

    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        byte[] bytes = rs.getBytes(colName);
        if (bytes != null && bytes.length != 0) {
            ByteArrayInputStream binaryInput = new ByteArrayInputStream(bytes);
            Throwable throwable = null;
            Object var6_7 = null;
            try (ObjectInputStream in = new ObjectInputStream(binaryInput);){
                return in.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    protected Object getJobDataFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            byte[] bytes = rs.getBytes(colName);
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            return new ByteArrayInputStream(bytes);
        }
        return this.getObjectFromBlob(rs, colName);
    }

    protected String toSqlLikeClause(GroupMatcher<?> matcher) {
        String groupName = super.toSqlLikeClause(matcher);
        return "%".equals(groupName) ? "%%" : groupName;
    }

    public List<TriggerKey> selectTriggerToAcquire(Connection conn, long noLaterThan, long noEarlierThan, int maxCount) throws SQLException {
        LinkedList<TriggerKey> linkedList;
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<TriggerKey> nextTriggers = new LinkedList<TriggerKey>();
        try {
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP, NEXT_FIRE_TIME, PRIORITY FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ? AND NEXT_FIRE_TIME <= ? AND (MISFIRE_INSTR = -1 OR (MISFIRE_INSTR != -1 AND NEXT_FIRE_TIME >= ?)) ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC"));
            if (maxCount < 1) {
                maxCount = 1;
            }
            ps.setString(1, "WAITING");
            ps.setBigDecimal(2, new BigDecimal(String.valueOf(noLaterThan)));
            ps.setBigDecimal(3, new BigDecimal(String.valueOf(noEarlierThan)));
            rs = ps.executeQuery();
            while (rs.next() && nextTriggers.size() < maxCount) {
                nextTriggers.add(TriggerKey.triggerKey((String)rs.getString("TRIGGER_NAME"), (String)rs.getString("TRIGGER_GROUP")));
            }
            linkedList = nextTriggers;
        }
        catch (Throwable throwable) {
            OrientDelegate.closeResultSet(rs);
            OrientDelegate.closeStatement((Statement)ps);
            throw throwable;
        }
        OrientDelegate.closeResultSet((ResultSet)rs);
        OrientDelegate.closeStatement((Statement)ps);
        return linkedList;
    }
}

