/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.upgrades;

import java.sql.Connection;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class JobDescriptionMigrationStep_1_3
extends ComponentSupport
implements DatabaseMigrationStep {
    private static final String QRTZ_JOB_DETAILS = "qrtz_job_details";
    private static final String QUARTZ_TRIGGERS = "qrtz_triggers";
    private static final String STATEMENT = "ALTER TABLE %s ALTER COLUMN description TYPE text";

    public Optional<String> version() {
        return Optional.of("1.3");
    }

    public void migrate(Connection connection) throws Exception {
        if (this.tableExists(connection, QRTZ_JOB_DETAILS) && this.tableExists(connection, QUARTZ_TRIGGERS)) {
            this.log.info("Changing 'description' column type from varchar(250) to text in table {}", (Object)QRTZ_JOB_DETAILS);
            this.runStatement(connection, String.format(STATEMENT, QRTZ_JOB_DETAILS));
            this.log.info("Changing 'description' column type from varchar(250) to text in table {}", (Object)QUARTZ_TRIGGERS);
            this.runStatement(connection, String.format(STATEMENT, QUARTZ_TRIGGERS));
        } else {
            this.log.warn("Table {} or {} doesn't exist, upgrade step {} will be skipped", new Object[]{QRTZ_JOB_DETAILS, QUARTZ_TRIGGERS, ((Object)((Object)this)).getClass().getSimpleName()});
        }
    }
}

