/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.task;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Trigger;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.quartz.internal.QuartzSchedulerSPI;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskFuture;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskInfo;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskState;
import org.sonatype.nexus.quartz.internal.task.QuartzTaskUtils;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskState;
import org.sonatype.nexus.scheduling.events.TaskEventStarted;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedCanceled;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedDone;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedFailed;
import org.sonatype.nexus.scheduling.schedule.Schedule;

public class QuartzTaskJobListener
extends ComponentSupport
implements JobListener {
    private final String name;
    private final EventManager eventManager;
    private final QuartzSchedulerSPI scheduler;
    private final QuartzTaskInfo taskInfo;

    public QuartzTaskJobListener(String name, EventManager eventManager, QuartzSchedulerSPI scheduler, QuartzTaskInfo taskInfo) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.scheduler = (QuartzSchedulerSPI)((Object)Preconditions.checkNotNull((Object)((Object)scheduler)));
        this.taskInfo = (QuartzTaskInfo)((Object)Preconditions.checkNotNull((Object)((Object)taskInfo)));
    }

    public QuartzTaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        JobKey jobKey = context.getJobDetail().getKey();
        this.log.trace("Job {} : {} jobToBeExecuted", (Object)jobKey.getName(), (Object)this.taskInfo.getConfiguration().getTaskLogName());
        Trigger currentTrigger = QuartzTaskUtils.getCurrentTrigger(context);
        QuartzTaskFuture future = this.taskInfo.getTaskFuture();
        if (future == null) {
            this.log.trace("Job {} : {} has no future, creating it", (Object)jobKey.getName(), (Object)this.taskInfo.getConfiguration().getTaskLogName());
            future = new QuartzTaskFuture(this.scheduler, jobKey, this.taskInfo.getConfiguration().getTaskLogName(), context.getFireTime(), this.scheduler.triggerConverter().convert(context.getTrigger()), null);
            this.taskInfo.setNexusTaskState(TaskState.RUNNING, new QuartzTaskState(QuartzTaskUtils.configurationOf(context.getJobDetail()), this.scheduler.triggerConverter().convert(currentTrigger), currentTrigger.getNextFireTime()), future);
        }
        context.put((Object)QuartzTaskFuture.FUTURE_KEY, (Object)future);
        context.put((Object)QuartzTaskInfo.TASK_INFO_KEY, (Object)this.taskInfo);
        this.eventManager.post((Object)new TaskEventStarted((TaskInfo)this.taskInfo));
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        JobKey jobKey = context.getJobDetail().getKey();
        this.log.trace("Job {} : {} jobWasExecuted", (Object)jobKey.getName(), (Object)this.taskInfo.getConfiguration().getTaskLogName());
        QuartzTaskFuture future = (QuartzTaskFuture)context.get((Object)QuartzTaskFuture.FUTURE_KEY);
        QuartzTaskInfo taskInfo = (QuartzTaskInfo)((Object)context.get((Object)QuartzTaskInfo.TASK_INFO_KEY));
        TaskState endState = future.isCancelled() ? TaskState.CANCELED : (jobException != null ? TaskState.FAILED : TaskState.OK);
        TaskConfiguration taskConfiguration = QuartzTaskUtils.configurationOf(context.getJobDetail());
        long runDuration = System.currentTimeMillis() - future.getStartedAt().getTime();
        taskConfiguration.setLastRunState(endState, future.getStartedAt(), runDuration);
        QuartzTaskUtils.updateJobData(context.getJobDetail(), taskConfiguration);
        this.log.trace("Job {} : {} lastRunState={}", new Object[]{jobKey.getName(), taskInfo.getConfiguration().getTaskLogName(), endState});
        Trigger currentTrigger = QuartzTaskUtils.getCurrentTrigger(context);
        Date nextFireTime = currentTrigger != null ? currentTrigger.getNextFireTime() : null;
        Schedule jobSchedule = this.scheduler.triggerConverter().convert(currentTrigger);
        TaskState state = !taskInfo.isRemovedOrDone() && nextFireTime != null ? TaskState.WAITING : TaskState.OK;
        JobExecutionException failure = jobException != null && jobException.getCause() instanceof Exception ? (Exception)jobException.getCause() : jobException;
        future.setResult(context.getResult(), (Exception)failure);
        taskInfo.setNexusTaskState(state, new QuartzTaskState(taskConfiguration, jobSchedule, nextFireTime), state.isDone() ? future : null);
        taskInfo.setLastResult(context.getResult());
        taskInfo.getContext().put("duration_ms", runDuration);
        switch (endState) {
            case OK: {
                this.eventManager.post((Object)new TaskEventStoppedDone((TaskInfo)taskInfo));
                break;
            }
            case FAILED: {
                this.eventManager.post((Object)new TaskEventStoppedFailed((TaskInfo)taskInfo, (Throwable)failure));
                break;
            }
            case CANCELED: {
                this.eventManager.post((Object)new TaskEventStoppedCanceled((TaskInfo)taskInfo));
            }
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public String getName() {
        return this.name;
    }

    public static String listenerName(JobKey jobKey) {
        return String.valueOf(QuartzTaskJobListener.class.getName()) + ":" + jobKey;
    }
}

