/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.sonatype.nexus.common.thread.TcclBlock;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.quartz.internal.orient.MarshalledEntity;
import org.sonatype.nexus.quartz.internal.orient.Marshaller;

public abstract class MarshalledEntityAdapter<T extends MarshalledEntity>
extends IterableEntityAdapter<T> {
    private static final String P_VALUE_TYPE = "value_type";
    private static final String P_VALUE_DATA = "value_data";
    private final Marshaller marshaller;
    private final ClassLoader classLoader;

    public MarshalledEntityAdapter(String typeName, Marshaller marshaller, ClassLoader classLoader) {
        super(typeName);
        this.marshaller = (Marshaller)Preconditions.checkNotNull((Object)marshaller);
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_VALUE_TYPE, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_VALUE_DATA, this.marshaller.getType()).setMandatory(true).setNotNull(true);
    }

    protected void readFields(ODocument document, MarshalledEntity entity) throws Exception {
        String valueType = (String)document.field(P_VALUE_TYPE);
        Preconditions.checkState((valueType != null ? 1 : 0) != 0, (String)"Marshalled document missing value_type: %s", (Object)document);
        Class<?> valueClass = this.classLoader.loadClass(valueType);
        Object valueData = document.field(P_VALUE_DATA);
        Preconditions.checkState((valueData != null ? 1 : 0) != 0, (String)"Marshalled document missing value_data: %s", (Object)document);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TcclBlock tccl = TcclBlock.begin((ClassLoader)this.classLoader);){
            Object value = this.marshaller.unmarshall(valueData, valueClass);
            entity.setValue(value);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void writeFields(ODocument document, MarshalledEntity entity) throws Exception {
        Object value = entity.getValue();
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"Marshalled entity missing value: %s", (Object)((Object)entity));
        String valueType = value.getClass().getName();
        document.field(P_VALUE_TYPE, (Object)valueType);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TcclBlock tccl = TcclBlock.begin((ClassLoader)this.classLoader);){
            Object valueData = this.marshaller.marshall(value);
            document.field(P_VALUE_DATA, valueData);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

