/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.quartz.JobKey;
import org.quartz.utils.Key;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.BrowseEntitiesWithPredicateAction;
import org.sonatype.nexus.orient.entity.action.DeleteEntitiesAction;
import org.sonatype.nexus.quartz.internal.orient.DeleteEntityByKeyAction;
import org.sonatype.nexus.quartz.internal.orient.ExistsByKeyAction;
import org.sonatype.nexus.quartz.internal.orient.FieldObjectMapper;
import org.sonatype.nexus.quartz.internal.orient.JacksonMarshaller;
import org.sonatype.nexus.quartz.internal.orient.JobCreatedEvent;
import org.sonatype.nexus.quartz.internal.orient.JobDeletedEvent;
import org.sonatype.nexus.quartz.internal.orient.JobDetailEntity;
import org.sonatype.nexus.quartz.internal.orient.JobUpdatedEvent;
import org.sonatype.nexus.quartz.internal.orient.MarshalledEntityAdapter;
import org.sonatype.nexus.quartz.internal.orient.Marshaller;
import org.sonatype.nexus.quartz.internal.orient.ReadEntityByKeyAction;

@Named
@Singleton
public class JobDetailEntityAdapter
extends MarshalledEntityAdapter<JobDetailEntity> {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("quartz").type("job_detail").build();
    private static final String P_NAME = "name";
    private static final String P_GROUP = "group";
    private static final String P_JOB_TYPE = "job_type";
    private static final String I_NAME_GROUP = new OIndexNameBuilder().type(DB_CLASS).property("name").property("group").build();
    private final ReadEntityByKeyAction<JobDetailEntity> readByKey = new ReadEntityByKeyAction(this, "name", "group");
    private final ExistsByKeyAction existsByKey = new ExistsByKeyAction((EntityAdapter<?>)this, "name", "group");
    private final BrowseEntitiesWithPredicateAction<JobDetailEntity> browseWithPredicate = new BrowseEntitiesWithPredicateAction((IterableEntityAdapter)this);
    private final DeleteEntityByKeyAction deleteByKey = new DeleteEntityByKeyAction((EntityAdapter<?>)this, "name", "group");
    private final DeleteEntitiesAction deleteAll = new DeleteEntitiesAction((EntityAdapter)this);

    public JobDetailEntityAdapter() {
        super(DB_CLASS, JobDetailEntityAdapter.createMarshaller(), JobDetailEntity.class.getClassLoader());
    }

    private static Marshaller createMarshaller() {
        return new JacksonMarshaller(new FieldObjectMapper());
    }

    @Override
    protected void defineType(OClass type) {
        super.defineType(type);
        type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_GROUP, OType.STRING).setMandatory(true).setNotNull(false);
        type.createProperty(P_JOB_TYPE, OType.STRING).setMandatory(true).setNotNull(true);
        type.createIndex(I_NAME_GROUP, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME, P_GROUP});
    }

    protected JobDetailEntity newEntity() {
        return new JobDetailEntity();
    }

    protected void readFields(ODocument document, JobDetailEntity entity) throws Exception {
        super.readFields(document, entity);
        entity.setName((String)document.field(P_NAME));
        entity.setGroup((String)document.field(P_GROUP));
        entity.setJobType((String)document.field(P_JOB_TYPE));
    }

    protected void writeFields(ODocument document, JobDetailEntity entity) throws Exception {
        super.writeFields(document, entity);
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_GROUP, (Object)entity.getGroup());
        document.field(P_JOB_TYPE, (Object)entity.getJobType());
    }

    @Nullable
    public JobDetailEntity readByKey(ODatabaseDocumentTx db, JobKey key) {
        return this.readByKey.execute(db, (Key)key);
    }

    public boolean existsByKey(ODatabaseDocumentTx db, JobKey key) {
        return this.existsByKey.execute(db, (Key)key);
    }

    public Iterable<JobDetailEntity> browseWithPredicate(ODatabaseDocumentTx db, Predicate<JobDetailEntity> predicate) {
        return this.browseWithPredicate.execute(db, predicate);
    }

    public boolean deleteByKey(ODatabaseDocumentTx db, JobKey key) {
        return this.deleteByKey.execute(db, (Key)key);
    }

    public void deleteAll(ODatabaseDocumentTx db) {
        this.deleteAll.execute(db);
    }

    public boolean sendEvents() {
        return true;
    }

    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        switch (eventKind) {
            case CREATE: {
                return new JobCreatedEvent((EntityMetadata)metadata);
            }
            case UPDATE: {
                return new JobUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new JobDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

