/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.ReflectionFactory;

class InstanceCreator {
    private static final Logger log = LoggerFactory.getLogger(InstanceCreator.class);
    private final UnsafeStrategy unsafeStrategy = UnsafeStrategy.create();

    public InstanceCreator() {
        log.trace("Unsafe strategy: {}", (Object)this.unsafeStrategy);
    }

    public <T> T newInstance(Class<T> type) throws Exception {
        Preconditions.checkNotNull(type);
        try {
            Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            log.trace("New instance: {}", type);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.trace("Failed to create instance of {} using standard constructor; trying unsafe strategy", type, (Object)e);
            return this.unsafeStrategy.newInstance(type);
        }
    }

    @IgnoreJRERequirement
    private static abstract class UnsafeStrategy {
        protected static final Logger log = LoggerFactory.getLogger(UnsafeStrategy.class);
        private final String name;

        public UnsafeStrategy(String name) {
            this.name = name;
        }

        public abstract <T> T newInstance(Class<T> var1) throws Exception;

        public String toString() {
            return this.name;
        }

        public static UnsafeStrategy create() {
            try {
                final ReflectionFactory rf = ReflectionFactory.getReflectionFactory();
                return new UnsafeStrategy("sun.reflect.ReflectionFactory"){

                    @Override
                    public <T> T newInstance(Class<T> type) throws Exception {
                        log.trace("New instance: {}", type);
                        Constructor<?> ctor = rf.newConstructorForSerialization(type, Object.class.getDeclaredConstructor(new Class[0]));
                        ctor.setAccessible(true);
                        Object instance = ctor.newInstance(new Object[0]);
                        return type.cast(instance);
                    }
                };
            }
            catch (Exception e) {
                log.trace("Failed to resolve ReflectionFactory", (Throwable)e);
                return new UnsafeStrategy("unsupported"){

                    @Override
                    public <T> T newInstance(Class<T> type) throws Exception {
                        throw new UnsupportedOperationException("Unable to create instance for: " + type);
                    }
                };
            }
        }
    }
}

