/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.quartz.internal.QuartzSchedulerSPI;
import org.sonatype.nexus.quartz.internal.orient.JobCreatedEvent;
import org.sonatype.nexus.quartz.internal.orient.JobDeletedEvent;
import org.sonatype.nexus.quartz.internal.orient.JobUpdatedEvent;
import org.sonatype.nexus.quartz.internal.orient.TriggerCreatedEvent;
import org.sonatype.nexus.quartz.internal.orient.TriggerDeletedEvent;
import org.sonatype.nexus.quartz.internal.orient.TriggerUpdatedEvent;

@Named
@FeatureFlag(name="nexus.clustered")
@Singleton
public class DistributedQuartzEventInspector
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    private final QuartzSchedulerSPI schedulerSPI;

    @Inject
    public DistributedQuartzEventInspector(QuartzSchedulerSPI schedulerSPI) {
        this.schedulerSPI = (QuartzSchedulerSPI)((Object)Preconditions.checkNotNull((Object)((Object)schedulerSPI)));
    }

    @Subscribe
    public void on(JobCreatedEvent event) {
        if (!event.isLocal() && this.schedulerSPI.isStarted()) {
            this.schedulerSPI.remoteJobCreated((JobDetail)event.getJob().getValue());
        }
    }

    @Subscribe
    public void on(JobUpdatedEvent event) throws SchedulerException {
        if (!event.isLocal() && this.schedulerSPI.isStarted()) {
            this.schedulerSPI.remoteJobUpdated((JobDetail)event.getJob().getValue());
        }
    }

    @Subscribe
    public void on(JobDeletedEvent event) throws SchedulerException {
        if (!event.isLocal() && this.schedulerSPI.isStarted()) {
            this.schedulerSPI.remoteJobDeleted((JobDetail)event.getJob().getValue());
        }
    }

    @Subscribe
    public void on(TriggerCreatedEvent event) throws SchedulerException {
        if (!event.isLocal() && this.schedulerSPI.isStarted()) {
            this.schedulerSPI.remoteTriggerCreated((Trigger)event.getTrigger().getValue());
        }
    }

    @Subscribe
    public void on(TriggerUpdatedEvent event) throws SchedulerException {
        if (!event.isLocal() && this.schedulerSPI.isStarted()) {
            this.schedulerSPI.remoteTriggerUpdated((Trigger)event.getTrigger().getValue());
        }
    }

    @Subscribe
    public void on(TriggerDeletedEvent event) throws SchedulerException {
        if (!event.isLocal() && this.schedulerSPI.isStarted()) {
            this.schedulerSPI.remoteTriggerDeleted((Trigger)event.getTrigger().getValue());
        }
    }
}

