/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.quartz.utils.ConnectionProvider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.quartz.orient.OrientConnectionProvider;
import org.sonatype.nexus.quartz.orient.OrientQuartzSchema;

@FeatureFlag(name="nexus.quartz.jobstore.orient")
@Named
@Singleton
public class ConfigOrientConnectionProvider
extends ComponentSupport
implements ConnectionProvider {
    private final Provider<DatabaseInstance> databaseInstance;
    private OrientConnectionProvider orientConnectionProvider;

    @Inject
    public ConfigOrientConnectionProvider(@Named(value="config") Provider<DatabaseInstance> databaseInstance) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
    }

    public Connection getConnection() throws SQLException {
        return this.orientConnectionProvider.getConnection();
    }

    public void shutdown() throws SQLException {
        if (this.orientConnectionProvider != null) {
            this.orientConnectionProvider.shutdown();
            this.orientConnectionProvider = null;
        }
    }

    public void initialize() throws SQLException {
        OrientConnectionProvider connProvider = new OrientConnectionProvider();
        connProvider.setConnectionString(this.getDatabaseUrl());
        connProvider.setUsePool(false);
        connProvider.initialize();
        this.orientConnectionProvider = connProvider;
    }

    private String getDatabaseUrl() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).acquire();){
            OrientQuartzSchema.register(db);
            return db.getURL();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

