/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobDataMap;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Daily;
import org.sonatype.nexus.scheduling.schedule.Hourly;
import org.sonatype.nexus.scheduling.schedule.Manual;
import org.sonatype.nexus.scheduling.schedule.Monthly;
import org.sonatype.nexus.scheduling.schedule.Now;
import org.sonatype.nexus.scheduling.schedule.Once;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.scheduling.schedule.ScheduleFactory;
import org.sonatype.nexus.scheduling.schedule.Weekly;

public class QuartzTriggerConverter
extends ComponentSupport {
    private final ScheduleFactory scheduleFactory;

    public QuartzTriggerConverter(ScheduleFactory scheduleFactory) {
        this.scheduleFactory = (ScheduleFactory)Preconditions.checkNotNull((Object)scheduleFactory);
    }

    public TriggerBuilder convert(Schedule schedule) {
        Object daysToRun;
        TriggerBuilder triggerBuilder;
        Cron s;
        Preconditions.checkNotNull((Object)schedule);
        if (schedule instanceof Cron) {
            s = (Cron)schedule;
            triggerBuilder = TriggerBuilder.newTrigger().startAt(s.getStartAt()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)s.getCronExpression()).inTimeZone(s.getTimeZone()));
        } else if (schedule instanceof Now) {
            triggerBuilder = TriggerBuilder.newTrigger().startNow();
        } else if (schedule instanceof Once) {
            s = (Once)schedule;
            triggerBuilder = TriggerBuilder.newTrigger().startAt(s.getStartAt());
        } else if (schedule instanceof Hourly) {
            s = (Hourly)schedule;
            triggerBuilder = TriggerBuilder.newTrigger().startAt(s.getStartAt()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatHourlyForever((int)1));
        } else if (schedule instanceof Daily) {
            s = (Daily)schedule;
            triggerBuilder = TriggerBuilder.newTrigger().startAt(s.getStartAt()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatHourlyForever((int)24));
        } else if (schedule instanceof Weekly) {
            s = (Weekly)schedule;
            daysToRun = s.getDaysToRun().stream().map(Weekly.Weekday.dayToString).collect(Collectors.joining(","));
            triggerBuilder = TriggerBuilder.newTrigger().startAt(s.getStartAt()).withSchedule((ScheduleBuilder)this.cron(s.getStartAt(), "? * " + (String)daysToRun));
        } else if (schedule instanceof Monthly) {
            s = (Monthly)schedule;
            daysToRun = s.getDaysToRun();
            boolean lastDayOfMonth = daysToRun.remove(Monthly.CalendarDay.lastDay());
            if (!lastDayOfMonth) {
                String daysToRunStr = daysToRun.stream().map(Monthly.CalendarDay.dayToString).collect(Collectors.joining(","));
                triggerBuilder = TriggerBuilder.newTrigger().startAt(s.getStartAt()).withSchedule((ScheduleBuilder)this.cron(s.getStartAt(), String.valueOf(daysToRunStr) + " * ?"));
            } else {
                triggerBuilder = TriggerBuilder.newTrigger().startAt(s.getStartAt()).withSchedule((ScheduleBuilder)this.cron(s.getStartAt(), "L * ?"));
            }
        } else if (schedule instanceof Manual) {
            triggerBuilder = TriggerBuilder.newTrigger().startAt(new Date(Long.MAX_VALUE));
        } else {
            throw new IllegalArgumentException("Schedule unknown: " + schedule.getType());
        }
        for (Map.Entry entry : schedule.asMap().entrySet()) {
            triggerBuilder.usingJobData((String)entry.getKey(), (String)entry.getValue());
        }
        return triggerBuilder;
    }

    private CronScheduleBuilder cron(Date date, String patternSuffix) {
        return CronScheduleBuilder.cronSchedule((String)(String.valueOf(QuartzTriggerConverter.cronTimeParts(date)) + " " + patternSuffix));
    }

    @VisibleForTesting
    static String cronTimeParts(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.format("0 %d %d", calendar.get(12), calendar.get(11));
    }

    public Schedule convert(Trigger trigger) {
        Preconditions.checkNotNull((Object)trigger);
        JobDataMap jobData = trigger.getJobDataMap();
        String type = jobData.getString("schedule.type");
        if ("cron".equals(type)) {
            Date startAt = Schedule.stringToDate((String)jobData.getString("schedule.startAt"));
            String cronExpression = jobData.getString("schedule.cronExpression");
            return this.scheduleFactory.cron(startAt, cronExpression);
        }
        if ("now".equals(type)) {
            return this.scheduleFactory.now();
        }
        if ("once".equals(type)) {
            Date startAt = Schedule.stringToDate((String)jobData.getString("schedule.startAt"));
            return this.scheduleFactory.once(startAt);
        }
        if ("hourly".equals(type)) {
            Date startAt = Schedule.stringToDate((String)jobData.getString("schedule.startAt"));
            return this.scheduleFactory.hourly(startAt);
        }
        if ("daily".equals(type)) {
            Date startAt = Schedule.stringToDate((String)jobData.getString("schedule.startAt"));
            return this.scheduleFactory.daily(startAt);
        }
        if ("weekly".equals(type)) {
            Date startAt = Schedule.stringToDate((String)jobData.getString("schedule.startAt"));
            Set daysToRun = Schedule.csvToSet((String)jobData.getString("schedule.daysToRun"), (Function)Weekly.Weekday.stringToDay);
            return this.scheduleFactory.weekly(startAt, daysToRun);
        }
        if ("monthly".equals(type)) {
            Date startAt = Schedule.stringToDate((String)jobData.getString("schedule.startAt"));
            Set daysToRun = Schedule.csvToSet((String)jobData.getString("schedule.daysToRun"), (Function)Monthly.CalendarDay.stringToDay);
            return this.scheduleFactory.monthly(startAt, daysToRun);
        }
        if ("manual".equals(type)) {
            return this.scheduleFactory.manual();
        }
        throw new IllegalArgumentException("Trigger unknown key: '" + trigger.getKey() + "', type: '" + type + "'");
    }
}

