/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.quartz.internal;

import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.subject.Subject;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;
import org.sonatype.nexus.security.subject.FakeAlmightySubject;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

public class QuartzThreadPool
implements ThreadPool {
    private final ThreadPoolExecutor threadPoolExecutor;
    private final NexusExecutorService nexusExecutorService;
    private final Semaphore semaphore;
    private String instanceId;
    private String instanceName;

    public QuartzThreadPool(int poolSize, int threadPriority) {
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)"Pool size must be greater than zero");
        Preconditions.checkArgument((threadPriority >= 1 && threadPriority <= 10 ? 1 : 0) != 0, (Object)String.format("Thread priority value must be an int between %s and %s", 1, 10));
        this.threadPoolExecutor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NexusThreadFactory("quartz", "nx-tasks", threadPriority), new ThreadPoolExecutor.AbortPolicy());
        this.nexusExecutorService = NexusExecutorService.forFixedSubject((ExecutorService)this.threadPoolExecutor, (Subject)FakeAlmightySubject.TASK_SUBJECT);
        this.semaphore = new Semaphore(poolSize);
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public int getPoolSize() {
        return this.threadPoolExecutor.getPoolSize();
    }

    public void initialize() throws SchedulerConfigException {
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.nexusExecutorService.shutdown();
        if (waitForJobsToComplete) {
            try {
                this.nexusExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean runInThread(Runnable runnable) {
        try {
            this.semaphore.acquire();
            this.nexusExecutorService.submit(this.semaphoreReleasingRunnable(runnable));
            return true;
        }
        catch (InterruptedException | RejectedExecutionException exception) {
            this.semaphore.release();
            return false;
        }
    }

    private Runnable semaphoreReleasingRunnable(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            finally {
                this.semaphore.release();
            }
        };
    }

    public int blockForAvailableThreads() {
        this.semaphore.acquire();
        try {
            int n = this.semaphore.availablePermits() + 1;
            this.semaphore.release();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.semaphore.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

