/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.legacy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.repository.httpbridge.internal.HttpBridgeModule;
import org.sonatype.nexus.repository.httpbridge.legacy.LegacyUrlCapabilityDescriptor;

@Named
@Singleton
public class LegacyUrlEnabledHelper {
    private final boolean supportLegacyContent = SystemPropertiesHelper.getBoolean((String)(String.valueOf(HttpBridgeModule.class.getName()) + ".legacy"), (boolean)false);
    private final CapabilityRegistry capabilities;

    @Inject
    public LegacyUrlEnabledHelper(CapabilityRegistry capabilities) {
        this.capabilities = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilities);
    }

    public boolean isEnabled() {
        return this.supportLegacyContent || this.isLegacyUrlCapabilityActive();
    }

    private boolean isLegacyUrlCapabilityActive() {
        Collection references = this.capabilities.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(LegacyUrlCapabilityDescriptor.TYPE));
        if (references.isEmpty()) {
            return false;
        }
        return ((CapabilityReference)references.iterator().next()).context().isActive();
    }
}

