/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.httpbridge.internal.LegacyHttpBridgeModule;
import org.sonatype.nexus.repository.httpbridge.legacy.LegacyUrlCapabilityDescriptor;
import org.sonatype.nexus.repository.httpbridge.legacy.LegacyUrlEnabledHelper;

@Named
@Singleton
@FeatureFlag(name="nexus.session.enabled")
public class LegacyHttpBridgeService
implements EventAware {
    private final MutableBeanLocator locator;
    private final LegacyUrlEnabledHelper legacyUrlEnabledHelper;
    private InjectorBindings legacyBridgeInjector;

    @Inject
    public LegacyHttpBridgeService(MutableBeanLocator locator, LegacyUrlEnabledHelper legacyUrlEnabledHelper) {
        this.locator = (MutableBeanLocator)Preconditions.checkNotNull((Object)locator);
        this.legacyUrlEnabledHelper = (LegacyUrlEnabledHelper)Preconditions.checkNotNull((Object)legacyUrlEnabledHelper);
        this.toggleLegacyHttpBridgeModule();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent event) {
        if (event.getReference().context().descriptor().type().equals((Object)LegacyUrlCapabilityDescriptor.TYPE)) {
            this.toggleLegacyHttpBridgeModule();
        }
    }

    private synchronized void toggleLegacyHttpBridgeModule() {
        if (this.legacyUrlEnabledHelper.isEnabled()) {
            this.addLegacyHttpBridgeModule();
        } else {
            this.removeLegacyHttpBridgeModule();
        }
    }

    protected AbstractModule getLegacyHttpBridgeModule() {
        return new LegacyHttpBridgeModule();
    }

    private void addLegacyHttpBridgeModule() {
        if (this.legacyBridgeInjector == null) {
            this.legacyBridgeInjector = new InjectorBindings(Guice.createInjector((Module[])new Module[]{new WireModule(new Module[]{this.getLegacyHttpBridgeModule(), new AbstractModule(){

                protected void configure() {
                    this.bind(BeanLocator.class).toInstance((Object)LegacyHttpBridgeService.this.locator);
                    Optional.ofNullable(LegacyHttpBridgeService.this.locator.locate(ParameterKeys.PROPERTIES)).map(Iterable::iterator).map(Iterator::next).map(b -> (Map)b.getValue()).ifPresent(m -> this.bind(ParameterKeys.PROPERTIES).toInstance(m));
                }
            }})}));
            this.locator.add((BindingPublisher)this.legacyBridgeInjector);
        }
    }

    private void removeLegacyHttpBridgeModule() {
        if (this.legacyBridgeInjector != null) {
            this.locator.remove((BindingPublisher)this.legacyBridgeInjector);
            this.legacyBridgeInjector = null;
        }
    }
}

