/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.sonatype.nexus.repository.view.PartPayload;

class HttpPartIteratorAdapter
implements Iterable<PartPayload> {
    private final HttpServletRequest httpRequest;

    public HttpPartIteratorAdapter(HttpServletRequest httpRequest) {
        this.httpRequest = (HttpServletRequest)Preconditions.checkNotNull((Object)httpRequest);
    }

    @Override
    public Iterator<PartPayload> iterator() {
        try {
            FileItemIterator itemIterator = new ServletFileUpload().getItemIterator(this.httpRequest);
            return new PayloadIterator(itemIterator);
        }
        catch (IOException | FileUploadException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isMultipart(HttpServletRequest httpRequest) {
        return FileUploadBase.isMultipartContent((RequestContext)new ServletRequestContext(httpRequest));
    }

    private static class FileItemStreamPayload
    implements PartPayload {
        private final FileItemStream next;

        public FileItemStreamPayload(FileItemStream next) {
            this.next = next;
        }

        public InputStream openInputStream() throws IOException {
            return this.next.openStream();
        }

        public long getSize() {
            return -1L;
        }

        @Nullable
        public String getContentType() {
            return this.next.getContentType();
        }

        @Nullable
        public String getName() {
            return this.next.getName();
        }

        public String getFieldName() {
            return this.next.getFieldName();
        }

        public boolean isFormField() {
            return this.next.isFormField();
        }
    }

    private static class PayloadIterator
    implements Iterator<PartPayload> {
        private final FileItemIterator itemIterator;

        public PayloadIterator(FileItemIterator itemIterator) {
            this.itemIterator = itemIterator;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.itemIterator.hasNext();
            }
            catch (IOException | FileUploadException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public PartPayload next() {
            try {
                return new FileItemStreamPayload(this.itemIterator.next());
            }
            catch (IOException | FileUploadException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

